(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    565361,      13021]
NotebookOptionsPosition[    558832,      12917]
NotebookOutlinePosition[    559273,      12934]
CellTagsIndexPosition[    559230,      12931]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Extract platelet thicknesses and radii from SAXS data", "Title",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138361009327*^9}, {3.889001234807024*^9, 
  3.889001235941153*^9}},ExpressionUUID->"9752d005-1219-465f-8e60-\
2082113917f8"],

Cell[TextData[{
 "This notebook contains the functions to calculate platelet thickness \
distributions from SAXS patterns.  Analysis of individual samples should be \
performed with the notebook ",
 StyleBox["Sample playground.nb",
  FontSlant->"Italic"],
 ".",
 "\nThe current notebook contains functions for the following steps:"
}], "Text",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138477031891*^9}, {3.8601400466828275`*^9, 
  3.8601400869865527`*^9}},ExpressionUUID->"49403409-d150-494f-b081-\
91ce56c28d83"],

Cell["\<\
Process (average, subtract background, merge), export and plot SAXS patterns\
\>", "Item",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 
  3.860138515531695*^9}},ExpressionUUID->"c5bb304f-f48f-4254-b437-\
103257a6e918"],

Cell["\<\
Data fitting (calculate (polydisperse) form factor, fit slopes (note that \
intensity fit has been remove for the full form factor incl platelet radius))\
\
\>", "Item",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138516926824*^9}, {3.8601386478729086`*^9, 
  3.860138664129044*^9}, {3.889498683509451*^9, 
  3.8894987072659907`*^9}},ExpressionUUID->"ae041ac8-eae0-47a3-9bd9-\
39e8721130f8"],

Cell[CellGroupData[{

Cell["Import data & setup functions", "Subsubsection",
 CellChangeTimes->{{3.854421073333592*^9, 
  3.854421085540827*^9}},ExpressionUUID->"e214e2f0-1723-47e3-b5e6-\
cc97977345b1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{3.891917782999442*^9, 3.9052283361177278`*^9},
 CellLabel->"In[43]:=",ExpressionUUID->"6a1e2f36-ed4d-4204-a5ee-f5fb0ba7e773"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], ",", 
       "\"\<2022-08_new_data/Graphene_data_capillaries_ave\>\""}], "}"}], 
     "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
       "\"\<2023-07_new_data/Laura-E-series\>\""}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"dataPath", "=", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
        "\"\<2023-07_new_data/Lisette\>\""}], "}"}], "]"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "dataPath", "=", 
     "\"\<C:\\\\Users\\\\s168562\\\\OneDrive-TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Graphene_data_capillaries_ave\>\""}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"dataPath", "=", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
        "\"\<2022-08_new_data/Graphene_data_capillaries_ave\>\""}], "}"}], 
      "]"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "dataPath", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fileNames", "=", 
     RowBox[{"FileNames", "[", 
      RowBox[{
      "RegularExpression", "[", "\"\<\\\\w+eiger2_\\\\d+_ave.h5\>\"", "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "fileNames", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.843291109702825*^9, 3.843291129724827*^9}, {
   3.843291167128108*^9, 3.843291185479764*^9}, {3.843291219598308*^9, 
   3.843291222024798*^9}, {3.843291264579451*^9, 3.8432912853783493`*^9}, 
   3.843291319173628*^9, {3.8432913509667788`*^9, 3.843291375972494*^9}, {
   3.843291451400524*^9, 3.843291477387067*^9}, {3.8432915074978447`*^9, 
   3.843291534313446*^9}, {3.843292849473691*^9, 3.843292942812584*^9}, {
   3.8432931554440536`*^9, 3.843293227171956*^9}, {3.843293396905971*^9, 
   3.8432934076677513`*^9}, {3.843293598815793*^9, 3.8432936066087017`*^9}, {
   3.84329364169765*^9, 3.843293676946286*^9}, {3.8432937236680613`*^9, 
   3.843293772333598*^9}, {3.843294707626026*^9, 3.843294724210083*^9}, 
   3.843294770372671*^9, {3.8432948815026712`*^9, 3.8432948844789762`*^9}, {
   3.843295139951911*^9, 3.843295151390843*^9}, {3.843296147653944*^9, 
   3.843296185726388*^9}, {3.843296554609067*^9, 3.843296592633421*^9}, {
   3.843296636066904*^9, 3.843296639883025*^9}, {3.8432966844608583`*^9, 
   3.843296707229643*^9}, {3.843296858083069*^9, 3.843296863457725*^9}, {
   3.843297628887661*^9, 3.8432976613287487`*^9}, {3.8432987537158613`*^9, 
   3.843298773059194*^9}, {3.843298823885009*^9, 3.843298834244919*^9}, {
   3.843299789697318*^9, 3.843299804010457*^9}, {3.852781031022092*^9, 
   3.8527810772744493`*^9}, {3.852781158568071*^9, 3.852781201094832*^9}, {
   3.8527812588052597`*^9, 3.852781283480824*^9}, {3.852781419697466*^9, 
   3.852781430649639*^9}, {3.852781469335927*^9, 3.852781497438036*^9}, {
   3.852781543616589*^9, 3.852781633868348*^9}, {3.8527816651702337`*^9, 
   3.852781748919075*^9}, {3.852781791308778*^9, 3.852781813234481*^9}, {
   3.8527818729040623`*^9, 3.852781874767733*^9}, {3.852782031664762*^9, 
   3.852782067804142*^9}, {3.852782890656323*^9, 3.852782892951396*^9}, 
   3.852784938827908*^9, 3.852785110185223*^9, 3.852785990266891*^9, {
   3.8527861525799932`*^9, 3.852786159462245*^9}, {3.8527862029249353`*^9, 
   3.852786226420244*^9}, {3.853381378758465*^9, 3.853381378945614*^9}, 
   3.853496150649447*^9, {3.8538177863332767`*^9, 3.8538177873549957`*^9}, 
   3.853818176511339*^9, {3.853833034447925*^9, 3.853833034613881*^9}, {
   3.854098398903439*^9, 3.8540983999200363`*^9}, {3.860137189571525*^9, 
   3.860137217401352*^9}, {3.885971180865988*^9, 3.885971188443076*^9}, {
   3.888309497309559*^9, 3.888309616445239*^9}, {3.8894988210904903`*^9, 
   3.889498848750657*^9}, {3.8895036360318656`*^9, 3.889503646388072*^9}, {
   3.8895036902148943`*^9, 3.8895037221118603`*^9}, {3.889503752320318*^9, 
   3.889503789653923*^9}, {3.8895039643492126`*^9, 3.889504039947297*^9}, {
   3.891917778214884*^9, 3.8919177861047926`*^9}, 3.9041237661720533`*^9, {
   3.9052284695314145`*^9, 3.9052284741268473`*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"bb5b9391-51b5-4754-9301-f8ac33c801e3"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2023-07_\
new_data\\\\Laura-E-series\"\>"], "Output",
 CellChangeTimes->{
  3.8895036121748714`*^9, 3.889503647604984*^9, 3.8895037225313816`*^9, 
   3.889503796811266*^9, 3.8895038798579345`*^9, {3.889504042983837*^9, 
   3.8895040528657637`*^9}, 3.889668463822626*^9, 3.890202604224517*^9, 
   3.890976837791486*^9, 3.8914129610421104`*^9, 3.891490100998623*^9, {
   3.8919177898508825`*^9, 3.891917801264139*^9}, 3.8919181780843434`*^9, 
   3.892609275047814*^9, 3.9023134693075624`*^9, 3.904123771407646*^9, 
   3.906015705863716*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"183a5e45-4fac-4246-945a-ca2643ce2245"],

Cell[BoxData["1069"], "Output",
 CellChangeTimes->{
  3.8895036121748714`*^9, 3.889503647604984*^9, 3.8895037225313816`*^9, 
   3.889503796811266*^9, 3.8895038798579345`*^9, {3.889504042983837*^9, 
   3.8895040528657637`*^9}, 3.889668463822626*^9, 3.890202604224517*^9, 
   3.890976837791486*^9, 3.8914129610421104`*^9, 3.891490100998623*^9, {
   3.8919177898508825`*^9, 3.891917801264139*^9}, 3.8919181780843434`*^9, 
   3.892609275047814*^9, 3.9023134693075624`*^9, 3.904123771407646*^9, 
   3.906015705966202*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"c85570ae-a5fa-467d-a6c7-3817ec81e012"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Extract", " ", "all", " ", "file", " ", "names"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetSharedVariable", "[", "j", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"j", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"titles", "=", 
       RowBox[{"ParallelTable", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"j", "++"}], ";", "\[IndentingNewLine]", 
          RowBox[{"title", "=", 
           RowBox[{"StringRiffle", "[", 
            RowBox[{
             RowBox[{"Import", "[", 
              RowBox[{
               RowBox[{"FileNameJoin", "[", 
                RowBox[{"{", 
                 RowBox[{"dataPath", ",", 
                  RowBox[{"fileNames", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\</entry_0000/PyFAI/id02-eiger2-saxs/header/Title\>\"", 
                  ",", "\"\</entry_0000/PyFAI/id02-eiger2-saxs/header/\
SampleDistance\>\""}], "}"}], "}"}]}], "]"}], ",", "\"\<_\>\""}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"title", ",", 
            RowBox[{"fileNames", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "fileNames", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", "j"}], 
     "\[IndentingNewLine]", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.852786431189885*^9, {3.852787104362198*^9, 3.852787107216403*^9}, {
   3.8534692703745604`*^9, 3.853469276630739*^9}, {3.853489232693318*^9, 
   3.853489233219405*^9}, {3.853499517183794*^9, 3.853499520757019*^9}, {
   3.8534995809431887`*^9, 3.853499582335005*^9}, {3.860137268641552*^9, 
   3.860137282028754*^9}, 
   3.906015964578121*^9},ExpressionUUID->"fc5fd8e9-fab4-4b5c-b2af-\
d0e7dff8366f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sampleFiles", "=", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"titles", ",", 
      RowBox[{"First", "\[Rule]", "Last"}]}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Group", " ", "files", " ", "by", " ", "their", " ", "sample", " ", 
    "name"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "import", " ", "q", " ", "data", " ", "for", 
    " ", "a", " ", "certain", " ", "filename"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scatteringDataFile", "[", "filename_", "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"filename", ",", "\"\</entry_0000/PyFAI/result_ave/q\>\""}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Import", "[", 
        RowBox[{
        "filename", ",", "\"\</entry_0000/PyFAI/result_ave/data\>\""}], "]"}],
        "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "\[Transpose]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "import", " ", "all", " ", "q", " ", "data", 
    " ", "files", " ", "for", " ", "one", " ", "sample"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSample", "[", "samplename_", "]"}], ":=", 
    RowBox[{"scatteringDataFile", "/@", 
     RowBox[{"sampleFiles", "[", "samplename", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"scatteringDataSampleAveraged", "[", "samplename_", "]"}], ":=", 
     
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"MeanAround", "/@", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], "}"}], 
        "\[Transpose]"}], "&"}], "@", 
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}]}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"scatteringDataSampleAveragedErrors", "[", "samplename_", "]"}], 
     ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"MeanAround", "/@", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], "}"}], 
        "\[Transpose]"}], "&"}], "@", 
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleAveraged", "[", "samplename_", "]"}], ":=", 
    RowBox[{"Mean", "[", 
     RowBox[{
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}], "\[Transpose]"}], "]"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Average", " ", "all", " ", "measurements"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleStdev", "[", "samplename_", "]"}], ":=", 
    RowBox[{"StandardDeviation", "[", 
     RowBox[{
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}], "\[Transpose]"}], "]"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Calculate", " ", "standard", " ", "deviation"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"scatteringDataSampleAveragedErrors", "[", "samplename_", "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
       "\[Transpose]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Calculate", " ", "average", " ", "and", " ", "stdev", " ", "in", " ", 
       "one", " ", "go"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Around", "@@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
            "\[Transpose]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"scatteringDataSampleStdev", "[", "samplename", "]"}], 
            "\[Transpose]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "\[Transpose]"}], 
       ")"}]}]}], "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}]}], "Input",\

 CellChangeTimes->{{3.852781860752527*^9, 3.852781861400449*^9}, {
   3.852782427495048*^9, 3.852782432845196*^9}, {3.852782490522458*^9, 
   3.8527825233607388`*^9}, 3.852782757511119*^9, {3.8527828983994617`*^9, 
   3.852782923717813*^9}, {3.852783954273013*^9, 3.852783958577043*^9}, {
   3.852784217988599*^9, 3.852784232189209*^9}, {3.852784588124271*^9, 
   3.852784630667053*^9}, 3.8527849493876867`*^9, 3.852786296410307*^9, {
   3.852786445171461*^9, 3.8527864639719877`*^9}, 3.852786739567677*^9, {
   3.852787449131702*^9, 3.852787450514557*^9}, {3.853381975213027*^9, 
   3.853381976205628*^9}, {3.853382404274076*^9, 3.85338240456852*^9}, {
   3.85340333020494*^9, 3.853403408623046*^9}, {3.85340345847932*^9, 
   3.853403507151403*^9}, {3.853409529667601*^9, 3.8534095895008907`*^9}, {
   3.853409682647615*^9, 3.853409684334144*^9}, {3.853410131707053*^9, 
   3.85341017818784*^9}, {3.8538181053955297`*^9, 3.853818151693227*^9}, {
   3.8538238300771923`*^9, 3.853823831444284*^9}, {3.8544235682712183`*^9, 
   3.854423596844871*^9}, {3.8601372879871793`*^9, 3.860137300912186*^9}, {
   3.8601373341336937`*^9, 3.860137513416378*^9}, {3.8601377878238845`*^9, 
   3.860137825471859*^9}, 3.8601381170176554`*^9, 3.8601381527942257`*^9},
 CellLabel->"In[51]:=",ExpressionUUID->"963c927a-6081-41b1-bcc3-11370c5e23da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Data processing functions", "Subsection"]], \
"Subsubsection",
 CellChangeTimes->{{3.8601381777337103`*^9, 3.8601382230184765`*^9}, {
  3.8601382660907316`*^9, 
  3.8601382667694025`*^9}},ExpressionUUID->"bb1efd3e-4cfd-424b-89f2-\
969547bc7a05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Function", " ", "to", " ", "subtract", " ", "background"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
     RowBox[{"samplename_", ",", "backgroundname_", ",", "c_"}], "]"}], ":=", 
    
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"scatdata", ",", "backdata"}], "}"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"scatdata", "=", 
        RowBox[{
         RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
         "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"backdata", "=", 
        RowBox[{
         RowBox[{"scatteringDataSampleAveraged", "[", "backgroundname", "]"}],
          "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"scatdata", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "==", 
          RowBox[{"backdata", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Select", "[", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
            "selecting", " ", "only", " ", "positive", " ", "intensities"}], 
            ";", " ", 
            RowBox[{"change", " ", "if", " ", "desired"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"scatdata", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"scatdata", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "-", 
               RowBox[{"c", " ", 
                RowBox[{"backdata", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], 
            "\[Transpose]"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Positive", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], "&"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "Null"}], "\[IndentingNewLine]", "]"}]}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Function", " ", "to", " ", "bin", " ", "the", " ", 
     RowBox[{"(", 
      RowBox[{"already", " ", 
       RowBox[{"averaged", "/", "background"}], " ", "subtracted", " ", "if", 
       " ", "desired"}], ")"}], " ", "data"}], "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"binData", "[", 
      RowBox[{"list_", ",", "binning_"}], "]"}], ":=", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"logData", "=", 
          RowBox[{"Log", "[", "list", "]"}]}], ",", "\[IndentingNewLine]", 
         "binnedRawLogData", ",", "\[IndentingNewLine]", "binnedLogData"}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumberQ", "[", "binning", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"binnedRawLogData", "=", 
           RowBox[{"BinListsBy", "[", 
            RowBox[{"logData", ",", 
             RowBox[{"{", 
              RowBox[{"First", ",", 
               RowBox[{"Min", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               RowBox[{"Max", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               "binning"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"binnedLogData", "=", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Mean", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "1"}], "]"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"MeanAround", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], 
             "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Return", "[", 
           RowBox[{"Exp", "[", "binnedLogData", "]"}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Function", " ", "to", " ", "export", " ", "a", " ", "dataset", " ", 
      "containing", " ", "three", " ", 
      RowBox[{"columns", ":", " ", "q"}]}], ",", " ", 
     RowBox[{"Mean", 
      RowBox[{"(", "I", ")"}], " ", "and", " ", "std", 
      RowBox[{"(", "I", ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"exportData", "[", "list_", "]"}], " ", ":=", " ", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"exportlist", " ", "=", " ", 
          RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"datamergedbinned", " ", "=", " ", "list"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"TrueQ", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Head", "[", 
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
               "Around"}], "||", 
              RowBox[{
               RowBox[{"Head", "[", 
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
               "Real"}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{
             "exportlist", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"Which", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"TrueQ", "[", 
                   RowBox[{
                    RowBox[{"Head", "[", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
                    "Around"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", 
                   "\"\<Value\>\"", "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"TrueQ", "[", 
                   RowBox[{
                    RowBox[{"Head", "[", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
                    "Real"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"datamergedbinned", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                  "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", 
                  "Null"}], "\[IndentingNewLine]", "]"}], ",", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"If", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Head", "[", "\[IndentingNewLine]", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], 
                    "\[IndentingNewLine]", "]"}], "\[Equal]", "Around"}], ",",
                   "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", 
                   "\"\<Uncertainty\>\"", "]"}], ",", "\[IndentingNewLine]", 
                  "0", ",", "\[IndentingNewLine]", "0"}], 
                 "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
               "}"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]",
            "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "datamergedbinned", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "exportlist", "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Function", " ", "to", " ", "extract", " ", "the", " ", "slopes", " ", 
     "from", " ", "the", " ", "pattern"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"slope", "[", 
      RowBox[{
       RowBox[{"list_", "?", "ListQ"}], ",", 
       RowBox[{"binning_", ":", "False"}]}], "]"}], ":=", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"logData", "=", 
          RowBox[{"Log", "[", "list", "]"}]}], ",", "\[IndentingNewLine]", 
         "binnedRawLogData", ",", "\[IndentingNewLine]", "binnedLogData", ",",
          "\[IndentingNewLine]", "slopesBinned", ",", "\[IndentingNewLine]", 
         "slopes"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumberQ", "[", "binning", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"binnedRawLogData", "=", 
           RowBox[{"BinListsBy", "[", 
            RowBox[{"logData", ",", 
             RowBox[{"{", 
              RowBox[{"First", ",", 
               RowBox[{"Min", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               RowBox[{"Max", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               "binning"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"binnedLogData", "=", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Mean", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "1"}], "]"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"MeanAround", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], 
             "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"slopesBinned", "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"MovingAverage", "[", 
                RowBox[{
                 RowBox[{"binnedLogData", "[", 
                  RowBox[{"[", 
                   RowBox[{";;", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], 
               "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "/", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "&"}], "/@", 
               RowBox[{"Differences", "[", "binnedLogData", "]"}]}]}], "}"}], 
            "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Return", "[", "slopesBinned", "]"}], ";"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"slopes", "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"MovingAverage", "[", 
                RowBox[{
                 RowBox[{"logData", "[", 
                  RowBox[{"[", 
                   RowBox[{";;", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], 
               "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "/", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "&"}], "/@", 
               RowBox[{"Differences", "[", "logData", "]"}]}]}], "}"}], 
            "\[Transpose]"}]}], ";", " ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
             RowBox[{
             "Return", " ", "in", " ", "the", " ", "first", " ", "column", 
              " ", "the", " ", "q"}], "-", 
             RowBox[{"value", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "actually", " ", "the", " ", "exponent", " ", "of", " ", 
                  "the", " ", "natural", " ", "log", " ", "of", " ", "the", 
                  " ", "q"}], "-", "value"}], ",", " ", 
                RowBox[{
                 RowBox[{"hence", " ", "the", " ", "q"}], "-", 
                 RowBox[{"value", " ", "itself"}]}]}], ")"}]}]}], ",", " ", 
            RowBox[{"in", " ", "the", " ", "second", " ", 
             RowBox[{
              RowBox[{"column", " ", "[", 
               RowBox[{
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"I", 
                   RowBox[{"(", 
                    RowBox[{"q", "+", "1"}], ")"}]}], ")"}]}], "-", 
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"I", 
                   RowBox[{"(", "q", ")"}]}], ")"}]}]}], "]"}], "/", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "1"}], ")"}]}], "-", 
                RowBox[{"ln", 
                 RowBox[{"(", "q", ")"}]}]}], "]"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
              "effectively", " ", "the", " ", "slope", " ", "in", " ", "each",
                " ", "point"}], ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"Return", "[", "slopes", "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"BinListsBy", "[", 
     RowBox[{"data_List", ",", " ", "binspecs__List"}], "]"}], " ", ":=", " ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "fs", ",", " ", "idata", ",", " ", "len", ",", " ", "out", ",", " ", 
        "dims"}], "}"}], ",", " ", 
      RowBox[{
       RowBox[{"len", " ", "=", " ", 
        RowBox[{"Length", "[", "data", "]"}]}], ";", " ", 
       RowBox[{"fs", " ", "=", " ", 
        RowBox[{"{", "binspecs", "}"}]}], ";", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"AllTrue", "[", 
          RowBox[{"fs", ",", " ", 
           RowBox[{
            RowBox[{"MatchQ", "[", 
             RowBox[{"#1", ",", " ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"_", ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}]}], "}"}], " ", "|", " ", 
               RowBox[{"{", 
                RowBox[{"_", ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "]"}], " ", 
            "&"}]}], " ", "]"}], ",", " ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"len", " ", ">", " ", "0"}], ",", " ", 
           RowBox[{
            RowBox[{"idata", " ", "=", " ", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"f", " ", "/@", " ", "data"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"f", ",", " ", 
                 RowBox[{"fs", "[", 
                  RowBox[{"[", 
                   RowBox[{"All", ",", "1"}], "]"}], "]"}]}], "}"}]}], 
              "]"}]}], ";", " ", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"idata", ",", " ", 
              RowBox[{"Range", "[", "len", "]"}]}], "]"}], ";", " ", 
            RowBox[{"out", " ", "=", " ", 
             RowBox[{"BinLists", "[", 
              RowBox[{
               RowBox[{"Transpose", "[", "idata", "]"}], ",", " ", 
               RowBox[{"Sequence", " ", "@@", " ", 
                RowBox[{"Rest", " ", "/@", " ", "fs"}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"0", ",", " ", 
                 RowBox[{"len", " ", "+", " ", "1"}], ",", " ", 
                 RowBox[{"len", " ", "+", " ", "1"}]}], "}"}]}], "]"}]}], ";",
             " ", 
            RowBox[{"out", " ", "=", " ", 
             RowBox[{"out", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"Sequence", " ", "@@", " ", 
                 RowBox[{"ConstantArray", "[", 
                  RowBox[{"All", ",", " ", 
                   RowBox[{"Length", "[", "fs", "]"}]}], "]"}]}], ",", "1", 
                ",", "All", ",", 
                RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";", " ", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", "#1", "]"}], "]"}], " ", "&"}], " ", ",", " ", 
              "out", ",", " ", 
              RowBox[{"{", 
               RowBox[{"Length", "[", "fs", "]"}], "}"}]}], "]"}]}], ",", " ", 
           RowBox[{
            RowBox[{"dims", " ", "=", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Length", "[", 
                  RowBox[{"Range", " ", "@@", " ", "#1"}], "]"}], " ", "-", 
                 " ", "1"}], " ", "&"}], " ", ")"}], " ", "/@", " ", 
              RowBox[{"Rest", " ", "/@", " ", "fs"}]}]}], ";", " ", 
            RowBox[{"ConstantArray", "[", 
             RowBox[{
              RowBox[{"{", "}"}], ",", " ", "dims"}], "]"}]}]}], "]"}], ",", 
         " ", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"BinListsBy", "::", "invalidspec"}], ",", " ", "fs"}], 
          "]"}]}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BinListsBy", "::", "invalidspec"}], " ", "=", " ", 
     "\"\<One or more of your binning specifications `1` is incorrect\
\[Ellipsis]\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Sort", "[", 
    RowBox[{"Keys", "[", "sampleFiles", "]"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Merging", " ", "data", " ", "sets"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"mergeData", "[", 
     RowBox[{
      RowBox[{"dataset1_", "?", "ListQ"}], ",", 
      RowBox[{"dataset2_", "?", "ListQ"}]}], "]"}], ":=", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data1", "=", 
         RowBox[{"Log", "[", "dataset1", "]"}]}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"data2", "=", 
         RowBox[{"Log", "[", "dataset2", "]"}]}], ",", "\[IndentingNewLine]", 
        "overlapRange", ",", "\[IndentingNewLine]", "overlap1", ",", 
        "\[IndentingNewLine]", "overlap2", ",", "\[IndentingNewLine]", 
        "overlappos", ",", "\[IndentingNewLine]", "scale", ",", 
        "\[IndentingNewLine]", "cutoff", ",", "\[IndentingNewLine]", 
        "cutoffno", ",", "\[IndentingNewLine]", "movingstdev"}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"overlapRange", "=", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
           RowBox[{
            RowBox[{"Max", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ">", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ">", 
            RowBox[{"Min", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Max", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}]}], 
            "\[IndentingNewLine]", ","}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], 
            ","}], "*)"}], "\[IndentingNewLine]", "True", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
          "Return", "[", "\"\<Error, no overlap, wrong order?\>\"", "]"}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"overlap1", "=", 
        RowBox[{"Select", "[", 
         RowBox[{"data1", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"overlap2", "=", 
        RowBox[{"Select", "[", 
         RowBox[{"data2", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"overlappos", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Nearest", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"overlap1", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "1"}], "]"}], "]"}], "\[Rule]", 
            RowBox[{"Range", "[", 
             RowBox[{"Length", "[", "overlap1", "]"}], "]"}]}], ",", 
           RowBox[{"overlap2", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"scale", "=", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Exp", "[", "c", "]"}], "/.", 
          RowBox[{
           RowBox[{"FindMinimum", "[", 
            RowBox[{
             RowBox[{"Norm", "[", 
              RowBox[{
               RowBox[{"overlap1", "[", 
                RowBox[{"[", 
                 RowBox[{"overlappos", ",", "2"}], "]"}], "]"}], "-", " ", 
               RowBox[{"overlap2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "2"}], "]"}], "]"}], "-", "c"}], "]"}], 
             ",", "c"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"movingstdev", "=", 
        RowBox[{"MovingAverage", "[", 
         RowBox[{
          RowBox[{"MovingMap", "[", 
           RowBox[{"StandardDeviation", ",", 
            RowBox[{
             RowBox[{"overlap1", "[", 
              RowBox[{"[", 
               RowBox[{"overlappos", ",", "2"}], "]"}], "]"}], "-", " ", 
             RowBox[{"overlap2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "2"}], "]"}], "]"}], "+", 
             RowBox[{"Log", "[", "scale", "]"}]}], ",", "10"}], "]"}], ",", 
          "10"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"cutoffno", "=", 
        RowBox[{"First", "[", 
         RowBox[{"First", "[", 
          RowBox[{"Position", "[", 
           RowBox[{"movingstdev", ",", 
            RowBox[{"_", "?", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"#", ">", "0.01"}], "&"}], ")"}]}]}], "]"}], "]"}], 
         "]"}]}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"was", " ", "0.1"}], ",", " ", 
         RowBox[{
         "but", " ", "gave", " ", "error", " ", "in", " ", "case", " ", "of", 
          " ", "already", " ", 
          RowBox[{"(", "almost", ")"}], " ", "overlapping", " ", "curves"}]}],
         " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"cutoff", "=", 
        RowBox[{"Exp", "[", 
         RowBox[{"overlap2", "[", 
          RowBox[{"[", 
           RowBox[{"cutoffno", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "\[IndentingNewLine]", 
        RowBox[{"Sort", "[", "\[IndentingNewLine]", 
         RowBox[{"Join", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{"dataset1", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "cutoff"}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"dataset2", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "scale"}], "}"}]}], "}"}]}]}], 
          "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.852781860752527*^9, 3.852781861400449*^9}, {
   3.852782427495048*^9, 3.852782432845196*^9}, {3.852782490522458*^9, 
   3.8527825233607388`*^9}, 3.852782757511119*^9, {3.8527828983994617`*^9, 
   3.852782923717813*^9}, {3.852783954273013*^9, 3.852783958577043*^9}, {
   3.852784217988599*^9, 3.852784232189209*^9}, {3.852784588124271*^9, 
   3.852784630667053*^9}, 3.8527849493876867`*^9, 3.852786296410307*^9, {
   3.852786445171461*^9, 3.8527864639719877`*^9}, 3.852786739567677*^9, {
   3.852787449131702*^9, 3.852787450514557*^9}, {3.853381975213027*^9, 
   3.853381976205628*^9}, {3.853382404274076*^9, 3.85338240456852*^9}, {
   3.85340333020494*^9, 3.853403408623046*^9}, {3.85340345847932*^9, 
   3.853403507151403*^9}, {3.853409529667601*^9, 3.8534095895008907`*^9}, {
   3.853409682647615*^9, 3.853409684334144*^9}, {3.853410131707053*^9, 
   3.85341017818784*^9}, {3.8538181053955297`*^9, 3.853818151693227*^9}, {
   3.8538238300771923`*^9, 3.853823831444284*^9}, {3.8544235682712183`*^9, 
   3.854423596844871*^9}, {3.8601372879871793`*^9, 3.860137300912186*^9}, {
   3.8601373341336937`*^9, 3.860137513416378*^9}, {3.8601377878238845`*^9, 
   3.860137825471859*^9}, 3.8601381170176554`*^9, {3.8601381527942257`*^9, 
   3.8601381554698157`*^9}, 3.860139314345042*^9, {3.8601396136069946`*^9, 
   3.860139637809037*^9}, {3.860140274802857*^9, 3.8601402881469436`*^9}, {
   3.8601403266498127`*^9, 3.860140345820403*^9}, {3.860140410589032*^9, 
   3.860140446255523*^9}, {3.8601404885987186`*^9, 3.8601405253716545`*^9}, {
   3.8601405888823967`*^9, 3.8601406208542633`*^9}, {3.860140651384527*^9, 
   3.86014076017659*^9}, {3.8601408369383373`*^9, 3.8601408546914597`*^9}, {
   3.8601412665787563`*^9, 3.860141297881263*^9}, 3.8629073718138065`*^9, {
   3.8636846731243887`*^9, 3.863684721178178*^9}, {3.8636849961195316`*^9, 
   3.8636850169326954`*^9}, {3.863685081135563*^9, 3.8636851178496304`*^9}, {
   3.863685275732274*^9, 3.863685280648721*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"f2858960-ee9b-434f-ab6f-b0967ca77d38"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"E10_10.0001\"\>", ",", "\<\"E10_1.5\"\>", 
   ",", "\<\"E10_30.9849\"\>", ",", "\<\"E1_10.0001\"\>", 
   ",", "\<\"E11_10.0001\"\>", ",", "\<\"E11_1.5\"\>", 
   ",", "\<\"E11_30.9849\"\>", ",", "\<\"E1_1.5\"\>", 
   ",", "\<\"E12_10.0001\"\>", ",", "\<\"E12_1.5\"\>", 
   ",", "\<\"E12_30.9849\"\>", ",", "\<\"E1_30.9849\"\>", 
   ",", "\<\"E13_10.0001\"\>", ",", "\<\"E13_1.5\"\>", 
   ",", "\<\"E13_30.9849\"\>", ",", "\<\"E14_10.0001\"\>", 
   ",", "\<\"E14_1.5\"\>", ",", "\<\"E14_30.9849\"\>", 
   ",", "\<\"E15_10.0001\"\>", ",", "\<\"E15_1.5\"\>", 
   ",", "\<\"E15_30.9849\"\>", ",", "\<\"E16_10.0001\"\>", 
   ",", "\<\"E16_1.5\"\>", ",", "\<\"E16_30.9849\"\>", 
   ",", "\<\"E17_10.0001\"\>", ",", "\<\"E17_1.5\"\>", 
   ",", "\<\"E17_30.9849\"\>", ",", "\<\"E18_10.0001\"\>", 
   ",", "\<\"E18_1.5\"\>", ",", "\<\"E18_30.9849\"\>", 
   ",", "\<\"E19_10.0001\"\>", ",", "\<\"E19_1.5\"\>", 
   ",", "\<\"E19_30.9849\"\>", ",", "\<\"E20_10.0001\"\>", 
   ",", "\<\"E20_1.5\"\>", ",", "\<\"E20_30.9849\"\>", 
   ",", "\<\"E2_10.0001\"\>", ",", "\<\"E21_10.0001\"\>", 
   ",", "\<\"E21_1.5\"\>", ",", "\<\"E21_30.9849\"\>", ",", "\<\"E2_1.5\"\>", 
   ",", "\<\"E22_10.0001\"\>", ",", "\<\"E22_1.5\"\>", 
   ",", "\<\"E22_30.9849\"\>", ",", "\<\"E2_30.9849\"\>", 
   ",", "\<\"E23_10.0001\"\>", ",", "\<\"E23_1.5\"\>", 
   ",", "\<\"E23_30.9849\"\>", ",", "\<\"E24_10.0001\"\>", 
   ",", "\<\"E24_1.5\"\>", ",", "\<\"E24_30.9849\"\>", 
   ",", "\<\"E25_10.0001\"\>", ",", "\<\"E25_1.5\"\>", 
   ",", "\<\"E25_30.9849\"\>", ",", "\<\"E26_10.0001\"\>", 
   ",", "\<\"E26_1.5\"\>", ",", "\<\"E26_30.9849\"\>", 
   ",", "\<\"E27_10.0001\"\>", ",", "\<\"E27_1.5\"\>", 
   ",", "\<\"E27_30.9849\"\>", ",", "\<\"E28_10.0001\"\>", 
   ",", "\<\"E28_1.5\"\>", ",", "\<\"E28_30.9849\"\>", 
   ",", "\<\"E29_10.0001\"\>", ",", "\<\"E29_1.5\"\>", 
   ",", "\<\"E29_30.9849\"\>", ",", "\<\"E30_10.0001\"\>", 
   ",", "\<\"E30_1.5\"\>", ",", "\<\"E30_30.9849\"\>", 
   ",", "\<\"E3_10.0001\"\>", ",", "\<\"E31_10.0001\"\>", 
   ",", "\<\"E31_1.5\"\>", ",", "\<\"E31_30.9849\"\>", ",", "\<\"E3_1.5\"\>", 
   ",", "\<\"E32_10.0001\"\>", ",", "\<\"E32_1.5\"\>", 
   ",", "\<\"E3_30.9849\"\>", ",", "\<\"E33_10.0001\"\>", 
   ",", "\<\"E33_1.5\"\>", ",", "\<\"E33_30.9849\"\>", ",", "\<\"E4_1.5\"\>", 
   ",", "\<\"E4_2_10.0001\"\>", ",", "\<\"E4_2_1.5\"\>", 
   ",", "\<\"E4_2_30.9849\"\>", ",", "\<\"E4_30.9849\"\>", 
   ",", "\<\"E5_10.0001\"\>", ",", "\<\"E5_1.5\"\>", 
   ",", "\<\"E5_30.9849\"\>", ",", "\<\"E6_10.0001\"\>", 
   ",", "\<\"E6_1.5\"\>", ",", "\<\"E6_30.9849\"\>", 
   ",", "\<\"E68_10.0001\"\>", ",", "\<\"E68_1.5\"\>", 
   ",", "\<\"E68_30.9849\"\>", ",", "\<\"E69_10.0001\"\>", 
   ",", "\<\"E69_1.5\"\>", ",", "\<\"E69_30.9849\"\>", 
   ",", "\<\"E70_10.0001\"\>", ",", "\<\"E70_1.5\"\>", 
   ",", "\<\"E70_30.9849\"\>", ",", "\<\"E7_10.0001\"\>", 
   ",", "\<\"E71_10.0001\"\>", ",", "\<\"E71_1.5\"\>", 
   ",", "\<\"E71_30.9849\"\>", ",", "\<\"E7_1.5\"\>", 
   ",", "\<\"E72_10.0001\"\>", ",", "\<\"E72_1.5\"\>", 
   ",", "\<\"E72_30.9849\"\>", ",", "\<\"E7_30.9849\"\>", 
   ",", "\<\"E8_10.0001\"\>", ",", "\<\"E8_1.5\"\>", 
   ",", "\<\"E8_30.9849\"\>", ",", "\<\"E9_10.0001\"\>", 
   ",", "\<\"E9_1.5\"\>", ",", "\<\"E9_30.9849\"\>", 
   ",", "\<\"MilliQ_10.0001\"\>", ",", "\<\"MilliQ_1.5\"\>", 
   ",", "\<\"MilliQ_30.9849\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.843291116410307*^9, 3.843291130190617*^9}, {
   3.8432911719097652`*^9, 3.843291185978409*^9}, 3.843291220560841*^9, {
   3.8432912704296637`*^9, 3.84329127392964*^9}, 3.843291320135066*^9, {
   3.8432913518879747`*^9, 3.8432913767025137`*^9}, {3.84329145300187*^9, 
   3.843291477899846*^9}, {3.843291512572294*^9, 3.843291534673026*^9}, 
   3.8432928114247313`*^9, 3.843292945133399*^9, {3.843293186383741*^9, 
   3.843293193473956*^9}, 3.843293608109157*^9, 3.843293645515916*^9, {
   3.843293716052813*^9, 3.843293730759082*^9}, {3.843293761080804*^9, 
   3.843293772865118*^9}, 3.8432938713954144`*^9, {3.84329471860441*^9, 
   3.8432947251573477`*^9}, 3.843294771162959*^9, 3.843294885917644*^9, 
   3.843295151895554*^9, 3.8432956501750383`*^9, 3.843296152599977*^9, {
   3.843296189871492*^9, 3.843296191243095*^9}, 3.84329659605822*^9, 
   3.843296864247712*^9, 3.843297654343287*^9, 3.843297684687933*^9, 
   3.843298780405675*^9, 3.8432988461417847`*^9, 3.843299816472809*^9, 
   3.852779404882422*^9, {3.852782926379023*^9, 3.852782939958962*^9}, 
   3.852783082585239*^9, 3.85278423842143*^9, 3.852784635998056*^9, 
   3.852784774684959*^9, 3.85278495816325*^9, 3.852785644257989*^9, 
   3.852786584046872*^9, 3.852787231457491*^9, 3.8527874512893887`*^9, 
   3.8528624946437807`*^9, 3.8533813666181393`*^9, 3.853381473051558*^9, 
   3.853382002859495*^9, {3.853382366117324*^9, 3.8533824068816853`*^9}, 
   3.853382447973559*^9, 3.853402237496472*^9, {3.8534035050061913`*^9, 
   3.853403520153386*^9}, {3.853409576568863*^9, 3.853409590687502*^9}, 
   3.853409686569212*^9, 3.853410179540357*^9, 3.85346909235686*^9, {
   3.853496221708645*^9, 3.853496230454815*^9}, 3.8534962722710114`*^9, 
   3.8534995714970713`*^9, 3.8534996217654676`*^9, {3.8534998537977457`*^9, 
   3.853499861198127*^9}, 3.853817842905547*^9, 3.8538182330499973`*^9, 
   3.853823854615374*^9, 3.853824682278778*^9, 3.8538248698359203`*^9, 
   3.8538330740724907`*^9, 3.853836452527369*^9, 3.853838538520102*^9, 
   3.854072553798176*^9, 3.854091674337735*^9, 3.854098459639974*^9, 
   3.8544207575313673`*^9, {3.854423578230679*^9, 3.854423602648951*^9}, 
   3.8601380332758555`*^9, 3.8601397073699045`*^9, 3.8601408681378775`*^9, 
   3.860141165553254*^9, 3.8617630814145107`*^9, 3.8617632495409374`*^9, 
   3.86194321925034*^9, 3.861950293500869*^9, 3.862109428120537*^9, 
   3.862204577976136*^9, 3.8859712433884926`*^9, 3.8859717023665004`*^9, 
   3.885973538318736*^9, 3.8871822213001337`*^9, 3.888309647401424*^9, 
   3.888309685383727*^9, 3.8883100772164288`*^9, 3.889001634921618*^9, 
   3.889060229645113*^9, 3.889064545330427*^9, 3.88908010527439*^9, 
   3.88908177519516*^9, 3.889082725590596*^9, 3.8890843099944553`*^9, 
   3.889498714652341*^9, 3.889499954222128*^9, 3.8895040850259047`*^9, 
   3.88966850980521*^9, 3.890202669873102*^9, 3.89097689186923*^9, 
   3.8914131817881813`*^9, 3.8914901650050025`*^9, 3.8919178772682314`*^9, 
   3.891918256701417*^9, 3.8926093273920903`*^9, 3.9023135005532465`*^9, 
   3.9041237961913223`*^9, 3.906015716956253*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"1c61ac8d-89bd-4e57-a2dd-0f614992ba6e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data fitting commands", "Subsection",
 CellChangeTimes->{{3.853833173909893*^9, 3.85383317510979*^9}, {
  3.854423364858252*^9, 
  3.854423369840681*^9}},ExpressionUUID->"9ecbbbc5-8b8f-4847-b220-\
8094510e4a4e"],

Cell["\<\
importing (or calculating -- which is very slow --, then saving) a table with \
all scattering patterns for a range of q, l, and r\
\>", "Text",
 CellChangeTimes->{{3.889001751397065*^9, 3.8890017945493183`*^9}, {
  3.8894989004771748`*^9, 
  3.8894989080000873`*^9}},ExpressionUUID->"1226fcdb-2e55-460d-933b-\
f363aeb6389f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"qmin", "=", 
    RowBox[{"-", "3"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qmax", "=", "1"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qstep", "=", "0.02"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qlist", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"qmin", ",", "qmax", ",", "qstep"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qlistslope", "=", 
    RowBox[{"Exp", "[", 
     RowBox[{"MovingAverage", "[", 
      RowBox[{
       RowBox[{"Log", "[", "qlist", "]"}], ",", "2"}], "]"}], "]"}]}], ";"}], 
  " ", 
  RowBox[{"(*", 
   RowBox[{"slope", "-", 
    RowBox[{
    "fitting", " ", "is", " ", "done", " ", "using", " ", "log", " ", 
     "scale"}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengthmin", "=", 
    RowBox[{"-", "1"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengthmax", "=", "3"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lengthstep", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengths", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"lengthmin", ",", "lengthmax", ",", "lengthstep"}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radiusmin", "=", "1"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radiusmax", "=", "4"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"radiusstep", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radii", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"radiusmin", ",", "radiusmax", ",", "radiusstep"}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", "lengths", "]"}], "*", 
   RowBox[{"Length", "[", "radii", "]"}]}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "number", " ", "of", " ", "combinations", " ", "of", " ", "L", " ", "and", 
    " ", "R"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "a", " ", "form", " ", "factor", " ", "for", " ", "disk", 
    " ", "with", " ", "radius", " ", "L", " ", "and", " ", "length", " ", "R",
     " ", 
    RowBox[{"(", 
     RowBox[{"Pedersen", " ", "1997"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"P11", "[", 
     RowBox[{"q_", ",", "R_", ",", "L_"}], "]"}], ":=", 
    RowBox[{"Quiet", "[", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"BesselJ", "[", 
              RowBox[{"1", ",", 
               RowBox[{"q", " ", "R", " ", 
                RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}], "]"}]}], 
            RowBox[{"q", " ", "R", " ", 
             RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]], " ", 
           FractionBox[
            RowBox[{"Sin", "[", 
             FractionBox[
              RowBox[{"q", " ", "L", " ", 
               RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], "2"], "]"}], 
            FractionBox[
             RowBox[{"q", " ", "L", " ", 
              RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], "2"]]}], ")"}], "2"], 
        RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", "0", ",", 
         FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"filename", "=", 
    RowBox[{"\"\<double polydisp data \>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{"Hash", "[", 
       RowBox[{"{", 
        RowBox[{"qlist", ",", "lengths", ",", "radii"}], "}"}], "]"}], "]"}], 
     "<>", "\"\<.mx\>\""}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Unfortunately", " ", "looks", " ", "like", " ", "this", " ", "hash", " ",
      "code", " ", "is", " ", "computer", " ", "specific"}], ",", " ", 
    RowBox[{
    "so", " ", "might", " ", "need", " ", "to", " ", "change", " ", "the", 
     " ", "file", " ", "name", " ", "of", " ", "the", " ", "existing", " ", 
     "table", " ", "to", " ", "this", " ", "name", " ", "if", " ", "you", " ",
      "want", " ", "to", " ", "reuse", " ", 
     RowBox[{"it", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"filename", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", "filename"}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "filename", " ", "=", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"If", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileExistsQ", "[", "filename", "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dataAllLengths", "=", 
       RowBox[{"<<", 
        RowBox[{"(", "filename", ")"}]}]}], ";"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SetSharedVariable", "[", "j", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"j", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"dataAllLengths", "=", 
          RowBox[{"Quiet", "[", "\[IndentingNewLine]", 
           RowBox[{"ParallelTable", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Table", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"j", "++"}], ";", "\[IndentingNewLine]", 
                RowBox[{"P11", "[", 
                 RowBox[{"qlist", ",", "radius", ",", "length"}], "]"}]}], 
               ",", "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{"length", ",", "lengths"}], "}"}]}], 
              "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"radius", ",", "radii"}], "}"}]}], 
            "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
         ";"}], ",", "\[IndentingNewLine]", "j"}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"dataAllLengths", ">>", 
       RowBox[{"(", "filename", ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "definition", " ", "of", " ", "probability", " ", "density", " ", 
    "function", " ", "and", " ", "function", " ", "to", " ", "calculate", " ",
     "intensities", " ", "with", " ", "both", " ", "L", " ", "and", " ", "R", 
    " ", 
    RowBox[{"unknown", "."}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"probfunc", "[", 
    RowBox[{
    "\[Mu]l_", ",", "\[Sigma]l_", ",", "\[Mu]r_", ",", "\[Sigma]r_", ",", 
     "l_", ",", "r_"}], "]"}], "=", "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"LogMultinormalDistribution", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[Mu]l", ",", "\[Mu]r"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SuperscriptBox["\[Sigma]l", "2"], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             SuperscriptBox["\[Sigma]r", "2"]}], "}"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "r"}], "}"}]}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"l", ">", "0"}], ",", 
        RowBox[{"r", ">", "0"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Calculate", " ", "intensities", " ", "for", " ", "the", " ", "platelets", 
    " ", "based", " ", "on", " ", "the", " ", "probability", " ", 
    "distributions", " ", "obtained", " ", "with", " ", "the", " ", "form", 
    " ", "factor", " ", 
    RowBox[{"fit", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"note", ";", " ", 
    RowBox[{
     RowBox[{
     "this", " ", "intensity", " ", "is", " ", "NOT", " ", "corrected", " ", 
      "for", " ", "the", " ", 
      RowBox[{"volume", "^", "2"}]}], "-", 
     RowBox[{
     "dependence", " ", "of", " ", "scattering", " ", "intensity", " ", 
      RowBox[{"(", 
       RowBox[{
       "can", " ", "be", " ", "easily", " ", "added", " ", "if", " ", "you", 
        " ", 
        RowBox[{"want", "!"}]}], ")"}]}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"calculateIntensitiesLR", "[", 
     RowBox[{
      RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"probabilities", ",", "data"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"probabilities", "=", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"probfunc", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", ",", 
            "l", ",", "r"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"probabilities", "=", 
        RowBox[{"probabilities", "/", 
         RowBox[{"Total", "[", 
          RowBox[{"Flatten", "[", "probabilities", "]"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Total", "[", "\[IndentingNewLine]", 
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"probabilities", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ".", 
               RowBox[{"dataAllLengths", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], ",", " ", 
              RowBox[{"(*", " ", 
               RowBox[{
                RowBox[{
                "why", " ", "do", " ", "we", " ", "not", " ", "need", " ", 
                 "to", " ", "call", " ", "the", " ", "form", " ", "factor", 
                 " ", 
                 RowBox[{"again", "?", " ", "Because"}], " ", "we", " ", 
                 "read", " ", "the", " ", "previously", " ", "calculated", 
                 " ", "table", " ", "I", " ", 
                 RowBox[{"think", ".", " ", "But"}], " ", 
                 RowBox[{"shouldn", "'"}], "t", " ", "we", " ", "correct", 
                 " ", "for", " ", "the", " ", "form", " ", "factor", " ", 
                 "vs", " ", "intensity", " ", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"i", ".", "e", ".", " ", "multiplying"}], " ", 
                    "with", " ", "A_dis"}], " ", "=", " ", 
                    RowBox[{"Pi", " ", 
                    RowBox[{"R", "^", "2"}]}]}], ")"}], "?"}]}], " ", "->", 
                " ", 
                RowBox[{
                "indeed", " ", "this", " ", "is", " ", "the", " ", "volume", 
                 " ", "dependence", " ", "of", " ", "the", " ", "scattering", 
                 " ", "function", " ", "that", " ", "Mark", " ", "is", " ", 
                 "refering", " ", "to", " ", 
                 RowBox[{"above", "."}]}]}], " ", "*)"}], 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"Length", "[", "probabilities", "]"}]}], "}"}]}], 
             "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
          "}"}], "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "data", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.853833992055169*^9, {3.853838966450965*^9, 3.853838966553301*^9}, {
   3.8544234235752993`*^9, 3.854423436127577*^9}, {3.854430087163003*^9, 
   3.854430130510928*^9}, {3.854430203830633*^9, 3.854430219131062*^9}, {
   3.8601385420212803`*^9, 3.860138638056221*^9}, {3.8601386828025064`*^9, 
   3.860138692836401*^9}, {3.8619498070714016`*^9, 3.861949810669832*^9}, {
   3.864111368481957*^9, 3.864111381547614*^9}, {3.8641119129600077`*^9, 
   3.864111933466826*^9}, {3.86411198099782*^9, 3.8641120377855062`*^9}, {
   3.864112243724079*^9, 3.8641122604900866`*^9}, {3.864112766219705*^9, 
   3.86411278769474*^9}, {3.8641135528767495`*^9, 3.8641135674698086`*^9}, {
   3.8641136364748583`*^9, 3.8641136872689133`*^9}, {3.864115609508887*^9, 
   3.864115696314577*^9}, {3.864115732636894*^9, 3.864115830964185*^9}, {
   3.8641158807267537`*^9, 3.8641158812495947`*^9}, {3.8641159142672977`*^9, 
   3.864115966691824*^9}, {3.8641160299919057`*^9, 3.8641160563528504`*^9}, {
   3.8641161004319696`*^9, 3.8641161468625154`*^9}, {3.8641161798404274`*^9, 
   3.8641161881638513`*^9}, {3.864116300781921*^9, 3.864116303316224*^9}, {
   3.864117598850899*^9, 3.864117610456077*^9}, {3.864117641542405*^9, 
   3.8641176697889366`*^9}, {3.864180413527955*^9, 3.864180439734521*^9}, {
   3.8641804809675617`*^9, 3.8641805484890027`*^9}, {3.864439294957782*^9, 
   3.8644393039048176`*^9}, {3.8644393915786576`*^9, 3.864439422827739*^9}, {
   3.864439453939878*^9, 3.864439469354518*^9}, {3.864439507094865*^9, 
   3.864439508154552*^9}, 3.8644397191828737`*^9, {3.8644398454503803`*^9, 
   3.8644398477143235`*^9}, {3.8644399339387035`*^9, 3.86443994606491*^9}, {
   3.886064903615081*^9, 3.8860649365245705`*^9}, {3.8860649824235754`*^9, 
   3.886065042163972*^9}, {3.8860654296691275`*^9, 3.8860654298245497`*^9}, {
   3.8860658521704564`*^9, 3.886065874983266*^9}, {3.886066040165041*^9, 
   3.886066041373247*^9}, {3.8860666771353765`*^9, 3.8860666867852397`*^9}, {
   3.887182510322879*^9, 3.887182533881962*^9}, 3.887182594924156*^9, {
   3.888309810352276*^9, 3.8883099090736856`*^9}, 3.888309979546259*^9, {
   3.889001517107656*^9, 3.889001521496806*^9}, 3.8890015518214397`*^9, {
   3.8890016534686737`*^9, 3.8890016557649727`*^9}, {3.8890018189941072`*^9, 
   3.8890019390049477`*^9}, {3.889001975497669*^9, 3.88900205859529*^9}, {
   3.8890029285899467`*^9, 3.889002953302465*^9}, {3.889061053677486*^9, 
   3.889061062588866*^9}, {3.889077630726709*^9, 3.889077637427123*^9}, {
   3.8890777314446993`*^9, 3.889077747654249*^9}, {3.88907998107436*^9, 
   3.889079982089085*^9}, {3.889080034422716*^9, 3.8890801182358418`*^9}, {
   3.889080169489069*^9, 3.889080169576085*^9}, {3.88949949386611*^9, 
   3.889499567193898*^9}, {3.8894998864287863`*^9, 3.8894998890429115`*^9}, {
   3.889500147504761*^9, 3.8895001771365824`*^9}, {3.8895002362490377`*^9, 
   3.8895002555469923`*^9}, 3.8896807810308504`*^9, {3.8896808952666397`*^9, 
   3.889680897469507*^9}, 3.8896809885482616`*^9, {3.889681435463972*^9, 
   3.889681467825818*^9}, {3.889683285411501*^9, 3.8896833249263334`*^9}, {
   3.8896836624629545`*^9, 3.889683726861018*^9}, {3.889683767007558*^9, 
   3.8896837811495934`*^9}, {3.8909840270444803`*^9, 3.890984036295034*^9}, 
   3.890984239308541*^9, {3.905228365161728*^9, 3.905228365907522*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"904598d3-3be1-4b29-9812-e84f814faf5c"],

Cell[BoxData["30351"], "Output",
 CellChangeTimes->{3.9060157171264696`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"681e62bd-fb47-4130-8710-47d38660d883"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Mu]l", "-", 
         RowBox[{"Log", "[", "l", "]"}]}], ")"}], "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Sigma]l", "2"]}]]}], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Mu]r", "-", 
        RowBox[{"Log", "[", "r", "]"}]}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]r", "2"]}]]}]], 
  RowBox[{"2", " ", "l", " ", "\[Pi]", " ", "r", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["\[Sigma]l", "2"], " ", 
     SuperscriptBox["\[Sigma]r", "2"]}]]}]]], "Output",
 CellChangeTimes->{3.906015729365367*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"ba2a6a4f-07e6-457d-8b60-12614192001f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Note", ":", " ", 
     RowBox[{
     "the", " ", "initial", " ", "values", " ", "are", " ", "optional"}]}], 
    ";", " ", 
    RowBox[{
    "if", " ", "you", " ", "omit", " ", "them", " ", "the", " ", "value", " ",
      "after", " ", 
     RowBox[{"the", " ", ":", " ", 
      RowBox[{"will", " ", "be", " ", 
       RowBox[{"assumed", ".", " ", "Fit"}], " ", "slopes", " ", "with", " ", 
       "this", " ", "discrete", " ", "full", " ", "form", " ", "factor", " ", 
       "\"\<function\>\""}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"fitSlopeLR", "[", 
     RowBox[{"data_", ",", 
      RowBox[{"\[Mu]linitial_", ":", 
       RowBox[{"Log", "[", "30.", "]"}]}], ",", 
      RowBox[{"\[Sigma]linitial_", ":", "0.5"}], ",", 
      RowBox[{"\[Mu]rinitial_", ":", 
       RowBox[{"Log", "[", "250.", "]"}]}], ",", 
      RowBox[{"\[Sigma]rinitial_", ":", "0.5"}], ",", " ", 
      RowBox[{"binfactor_", ":", "0.15"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dataSlope", "=", 
         RowBox[{"slope", "[", 
          RowBox[{"data", ",", "binfactor"}], "]"}]}], ",", 
        "\[IndentingNewLine]", "qListDataSlope"}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"qListDataSlope", "=", 
        RowBox[{"dataSlope", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "1"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"minfuncslopeLR", "[", 
         RowBox[{
          RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"slope", "[", 
             RowBox[{"calculateIntensitiesLR", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
              "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"Flatten", "[", 
               RowBox[{"Nearest", "[", 
                RowBox[{
                 RowBox[{"qlistslope", "\[Rule]", "\"\<Index\>\""}], ",", 
                 "qListDataSlope"}], "]"}], "]"}], ",", "2"}], "]"}], "]"}], 
           "-", "\[IndentingNewLine]", 
           RowBox[{"dataSlope", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "2"}], "]"}], "]"}]}], "]"}], "[", 
         "\"\<Value\>\"", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"fmfSLR", "=", 
        RowBox[{"FindMinimum", "[", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"minfuncslopeLR", "[", 
             RowBox[{
             "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
             "]"}], " ", ",", " ", 
            RowBox[{"\[Mu]l", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Sigma]l", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Mu]r", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Sigma]r", ">", "0"}]}], " ", "}"}], "*)"}], " ", 
         RowBox[{"(*", " ", 
          RowBox[{"constraint", ":", " ", 
           RowBox[{"sigma", " ", ">", " ", "0"}]}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"minfuncslopeLR", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
           "]"}], "*)"}], "  ", 
         RowBox[{"(*", " ", "default", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"minfuncslopeLR", "[", 
           RowBox[{
            RowBox[{"Abs", "[", "\[Mu]l", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Sigma]l", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Mu]r", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Sigma]r", "]"}]}], " ", 
           RowBox[{"(*", " ", 
            RowBox[{
            "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent",
              " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"AccuracyGoal", " ", "->", " ", "5"}], ",", " ", 
             RowBox[{"PrecisionGoal", " ", "->", " ", "5"}]}], "*)"}], "]"}], 
          "  ", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Try", " ", "to", " ", "reduce", " ", "computation", " ", "time", 
            " ", "by", " ", "asking", " ", "for", " ", "lower", " ", 
            "accuracy", " ", "and", " ", 
            RowBox[{"precision", "."}]}], "*)"}], "\[IndentingNewLine]", ",", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Mu]l", ",", "\[Mu]linitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]l", ",", "\[Sigma]linitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Mu]r", ",", "\[Mu]rinitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]r", ",", "\[Sigma]rinitial"}], "}"}]}], "}"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<\[Mu]l = \>\"", ",", "\[Mu]l", ",", "\"\< \[Sigma]l = \>\"", 
             ",", "\[Sigma]l", ",", "\"\< \[Mu]r = \>\"", ",", 
             RowBox[{"\[Mu]r", "\"\< \[Sigma]r = \>\""}], ",", "\[Sigma]r"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Method", "->", "\"\<QuasiNewton\>\""}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "->", 
             RowBox[{"Abs", "[", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "&"}], "/@", 
           RowBox[{"fmfSLR", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "~", "Join", "~", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Mu]lx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]l", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]l", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]lx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]l"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]l", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]l", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}], ",", 
             RowBox[{"\[Mu]rx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]r", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]r", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]rx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]r"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]r", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]r", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}]}], "}"}], "/.", 
           RowBox[{"fmfSLR", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], 
        RowBox[{"(*", " ", 
         RowBox[{
         "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent", 
          " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.853833992055169*^9, {3.853838966450965*^9, 3.853838966553301*^9}, {
   3.8544234235752993`*^9, 3.854423436127577*^9}, {3.854430087163003*^9, 
   3.854430130510928*^9}, {3.854430203830633*^9, 3.854430219131062*^9}, {
   3.8601385420212803`*^9, 3.860138638056221*^9}, {3.8601386828025064`*^9, 
   3.860138692836401*^9}, {3.8619498070714016`*^9, 3.861949810669832*^9}, {
   3.864111368481957*^9, 3.864111381547614*^9}, {3.8641119129600077`*^9, 
   3.864111933466826*^9}, {3.86411198099782*^9, 3.8641120377855062`*^9}, {
   3.864112243724079*^9, 3.8641122604900866`*^9}, {3.864112766219705*^9, 
   3.86411278769474*^9}, {3.8641135528767495`*^9, 3.8641135674698086`*^9}, {
   3.8641136364748583`*^9, 3.8641136872689133`*^9}, {3.864115609508887*^9, 
   3.864115696314577*^9}, {3.864115732636894*^9, 3.864115830964185*^9}, {
   3.8641158807267537`*^9, 3.8641158812495947`*^9}, {3.8641159142672977`*^9, 
   3.864115966691824*^9}, {3.8641160299919057`*^9, 3.8641160563528504`*^9}, {
   3.8641161004319696`*^9, 3.8641161468625154`*^9}, {3.8641161798404274`*^9, 
   3.8641161881638513`*^9}, {3.864116300781921*^9, 3.864116303316224*^9}, {
   3.864117598850899*^9, 3.864117610456077*^9}, {3.864117641542405*^9, 
   3.8641176697889366`*^9}, {3.864180413527955*^9, 3.864180439734521*^9}, {
   3.8641804809675617`*^9, 3.8641805484890027`*^9}, {3.864439294957782*^9, 
   3.8644393039048176`*^9}, {3.8644393915786576`*^9, 3.864439422827739*^9}, {
   3.864439453939878*^9, 3.864439469354518*^9}, {3.864439507094865*^9, 
   3.864439508154552*^9}, 3.8644397191828737`*^9, {3.8644398454503803`*^9, 
   3.8644398477143235`*^9}, {3.8644399339387035`*^9, 3.86443994606491*^9}, {
   3.886064903615081*^9, 3.8860649365245705`*^9}, {3.8860649824235754`*^9, 
   3.886065042163972*^9}, {3.8860654296691275`*^9, 3.8860654298245497`*^9}, {
   3.8860658521704564`*^9, 3.886065874983266*^9}, {3.886066040165041*^9, 
   3.886066041373247*^9}, {3.8860666771353765`*^9, 3.8860666867852397`*^9}, {
   3.887182510322879*^9, 3.887182533881962*^9}, 3.887182594924156*^9, {
   3.888309810352276*^9, 3.8883099090736856`*^9}, 3.888309979546259*^9, {
   3.889001517107656*^9, 3.889001521496806*^9}, 3.8890015518214397`*^9, {
   3.8890016534686737`*^9, 3.8890016557649727`*^9}, {3.8890018189941072`*^9, 
   3.8890019390049477`*^9}, {3.889001975497669*^9, 3.8890020072173767`*^9}, {
   3.889002614228364*^9, 3.8890026313484697`*^9}, {3.889077832884159*^9, 
   3.889077894603732*^9}, {3.889080182454623*^9, 3.889080182537393*^9}, {
   3.8890822541823463`*^9, 3.8890822952851562`*^9}, {3.889082341655233*^9, 
   3.889082344557757*^9}, {3.889082656479224*^9, 3.8890826670260477`*^9}, {
   3.8890828570654707`*^9, 3.889082869681726*^9}, {3.889082911422908*^9, 
   3.889082918957836*^9}, {3.8895003750115547`*^9, 3.8895003897150297`*^9}, {
   3.8895018994156485`*^9, 3.8895019010220375`*^9}, {3.889503150539938*^9, 
   3.8895031777290506`*^9}, {3.8896809063671813`*^9, 
   3.8896810153449264`*^9}, {3.8896810571842823`*^9, 
   3.8896811412259593`*^9}, {3.889681489021313*^9, 3.8896815167211204`*^9}, {
   3.8896816106523666`*^9, 3.8896817796390357`*^9}, {3.8896820398977776`*^9, 
   3.889682095914321*^9}, 3.8896821349393435`*^9, {3.889682203278436*^9, 
   3.8896822073970346`*^9}, 3.889682405803105*^9, {3.889683225636203*^9, 
   3.8896832268268085`*^9}, {3.889683264087661*^9, 3.8896832726744494`*^9}, {
   3.8902008849918118`*^9, 3.890200911254434*^9}, {3.891414478168077*^9, 
   3.89141454535581*^9}, {3.8914145789251857`*^9, 3.891414624133849*^9}, {
   3.8914150625685744`*^9, 3.8914152262658043`*^9}, {3.8914159481837835`*^9, 
   3.8914159627995386`*^9}, {3.891417522295415*^9, 3.8914175385413494`*^9}, 
   3.891427879634804*^9, {3.891427987429741*^9, 3.8914280388778486`*^9}, {
   3.8914908223125954`*^9, 3.8914908272757816`*^9}, {3.905228372076123*^9, 
   3.905228384803872*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"4d2ca9cf-a791-490d-b630-3cfaa5886fc0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot settings", "Section",
 CellChangeTimes->{{3.9042103487363567`*^9, 
  3.904210353447942*^9}},ExpressionUUID->"ea7d68f2-5356-49b3-95f0-\
1a6e38787f2a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"inch", " ", "=", " ", "84"}], " ", ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Should", " ", "be", " ", "72", " ", "for", " ", "Mac", " ", "or", " ", 
     "96", " ", "for", " ", "windows"}], ",", " ", 
    RowBox[{
    "but", " ", "somehow", " ", "I", " ", "dont", " ", "obtain", " ", "the", 
     " ", "specified", " ", "image", " ", "sizes", " ", "that", " ", 
     RowBox[{"way", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cm", " ", "=", " ", 
   RowBox[{"inch", "/", "2.54"}]}], ";"}]}], "Input",
 CellLabel->"In[86]:=",ExpressionUUID->"1e2ec847-da37-43d8-8641-1323717c97b4"],

Cell[CellGroupData[{

Cell["\<\
Function to get logarithmic tick marks in scientific notation\
\>", "Subsection",
 CellChangeTimes->{{3.889675803215909*^9, 
  3.889675825628518*^9}},ExpressionUUID->"2c7e915b-284b-4a52-9077-\
42b65bc60a51"],

Cell["\<\
From https://stackoverflow.com/questions/5669073/force-scientific-notation-in-\
tick-labels-of-listloglogplot. \[LineSeparator]Was really annoyed that \
apparently it\[CloseCurlyQuote]s super hard to choose your own tick labels in \
mathematica in combination with logarithmic tick marks\
\>", "Text",
 CellChangeTimes->{{3.8896758423204074`*^9, 3.889675874699585*^9}, {
  3.8896759137086077`*^9, 
  3.8896759250674143`*^9}},ExpressionUUID->"0716ec73-f7da-4d51-adfc-\
df2d5f6b72d6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PowerTicks", "[", "label_", "]"}], "[", 
    RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"min10", ",", "max10"}], "}"}], ",", 
     RowBox[{
      RowBox[{"min10", "=", 
       RowBox[{"Floor", "[", 
        RowBox[{"Log10", "[", "min", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"max10", "=", 
       RowBox[{"Ceiling", "[", 
        RowBox[{"Log10", "[", "max", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", "i"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{"label", ",", 
              RowBox[{"Superscript", "[", 
               RowBox[{"10", ",", "i"}], "]"}], ",", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
          
          RowBox[{"{", 
           RowBox[{"i", ",", "min10", ",", "max10"}], "}"}]}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"k", " ", 
               RowBox[{"10", "^", "i"}]}], ",", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
       "]"}]}]}], "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"use", " ", "example"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Range", "[", "20", "]"}], "^", "3"}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}]}], 
    "]"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "skip", " ", "every", " ", "second", " ", "tick", " ", "label", " ", "for",
     " ", "readability"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PowerTicks2", "[", "label_", "]"}], "[", 
   RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"min10", ",", "max10"}], "}"}], ",", 
    RowBox[{
     RowBox[{"min10", "=", 
      RowBox[{"Floor", "[", 
       RowBox[{"Log10", "[", "min", "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"max10", "=", 
      RowBox[{"Ceiling", "[", 
       RowBox[{"Log10", "[", "max", "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"10", "^", "i"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{"label", ",", 
               RowBox[{"Superscript", "[", 
                RowBox[{"10", ",", "i"}], "]"}], ",", 
               RowBox[{"Spacer", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "min10", ",", "max10", ",", "2"}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", " ", 
                RowBox[{"10", "^", "i"}]}], ",", 
               RowBox[{"Spacer", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
        "]"}], "]"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", "i"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{"label", ",", 
             RowBox[{"Superscript", "[", 
              RowBox[{"10", ",", "i"}], "]"}], ",", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "min10", ",", "max10", ",", "2"}], "}"}]}], "]"}],
        ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", "i"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{"label", ",", " ", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"10", "min10"}], ",", 
           RowBox[{"10", "max10"}], ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"k", " ", 
              RowBox[{"10", "^", "i"}]}], ",", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], ",", 
           
           RowBox[{"{", 
            RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
      "]"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.8896758773232393`*^9, {3.8896759377796016`*^9, 3.889675951308181*^9}, 
   3.9041934750089507`*^9, 3.904210369538686*^9},
 CellLabel->"In[88]:=",ExpressionUUID->"3ff1d24a-bfe7-4aef-b22b-89321bdbef81"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Title",
 CellChangeTimes->{{3.889081816418654*^9, 
  3.8890818172763433`*^9}},ExpressionUUID->"d8104e96-bcdf-4d40-8ea7-\
520991da3e70"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "EXAMPLE", " ", "plots", " ", "of", " ", "the", " ", "monodisperse", " ", 
     "and", " ", "polydisperse", " ", "form", " ", 
     RowBox[{
     "factors", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "They"}], 
     " ", "are", " ", "very", " ", "similar"}], ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "the", " ", "one", " ", 
      RowBox[{"(", "P11", ")"}], " ", "for", " ", "actual", " ", "disks", " ",
       "is", " ", 
      RowBox[{"better", ":", " ", 
       RowBox[{"the", " ", "form", " ", "factor", " ", "P", 
        RowBox[{"(", "Q", ")"}], " ", "is", " ", "always", " ", "1", " ", 
        "for", " ", "Q"}]}]}], "->", 
     RowBox[{"0.", " ", "For", " ", "the", " ", "lamellae", " ", "P", 
      RowBox[{"(", 
       RowBox[{"Q", "->", "0"}], ")"}], " ", "depends", " ", "on", " ", "the",
       " ", "thickness", " ", "L"}]}], ",", " ", 
    RowBox[{
     RowBox[{
     "which", " ", "influences", " ", "results", " ", "when", " ", "fitting", 
      " ", "polydisperse", " ", "cases"}], ";", " ", 
     RowBox[{"see", " ", "slope", " ", "plot", " ", 
      RowBox[{"below", "."}]}]}]}], "\[IndentingNewLine]", " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"Isheets", "[", 
           RowBox[{"qlist", ",", "10"}], "]"}]}], "}"}], "\[Transpose]"}], 
       ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"Isheets", "[", 
           RowBox[{"qlist", ",", "40"}], "]"}]}], "}"}], "\[Transpose]"}], 
       ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"P11", "[", 
           RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
        "\[Transpose]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"P11", "[", 
           RowBox[{"qlist", ",", "250", ",", "40"}], "]"}]}], "}"}], 
        "\[Transpose]"}]}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Joined", "->", "True"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", 
         RowBox[{"Log", "[", "250.", "]"}], ",", "0.3"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"intPolydisp", "[", 
        RowBox[{
         RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", "qlist", ",", 
         RowBox[{"10", "^", 
          RowBox[{"-", "3.3"}]}]}], "]"}]}], "\[IndentingNewLine]", "}"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", 
          RowBox[{"Log", "[", "250.", "]"}], ",", "0.2"}], "]"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"slope", "[", 
        RowBox[{"intPolydisp", "[", 
         RowBox[{
          RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", "qlist", ",", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3.3"}]}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"one", " ", "example", " ", "form", " ", "factor"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Isheets", "[", 
            RowBox[{"qlist", ",", "10"}], "]"}]}], "}"}], "\[Transpose]"}], 
        ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Isheets", "[", 
            RowBox[{"qlist", ",", "40"}], "]"}]}], "}"}], "\[Transpose]"}], 
        ","}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"qlist", ",", 
         RowBox[{"P11", "[", 
          RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
       "\[Transpose]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"P11", "[", 
           RowBox[{"qlist", ",", "250", ",", "40"}], "]"}]}], "}"}], 
        "\[Transpose]"}], "*)"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "one", " ", "example", " ", "polydisperse", " ", "form", " ", "factor"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
        RowBox[{"Log", "[", "10.", "]"}], ",", "0.8", ",", 
        RowBox[{"Log", "[", "250.", "]"}], ",", "0.5"}], "]"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"intPolydisp", "[", 
        RowBox[{
         RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", "qlist", ",", 
         RowBox[{"10", "^", 
          RowBox[{"-", "3.3"}]}]}], "]"}], "*)"}], "\[IndentingNewLine]", 
      "}"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculated", " ", "slopes", " ", "for", " ", "one", " ", "example"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"slope", "[", 
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"Log", "[", "10.", "]"}], ",", "0.8", ",", 
         RowBox[{"Log", "[", "250.", "]"}], ",", "0.5"}], "]"}], "]"}], 
      "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.853833992055169*^9, {3.853838966450965*^9, 3.853838966553301*^9}, {
   3.8544234235752993`*^9, 3.854423436127577*^9}, {3.854430087163003*^9, 
   3.854430130510928*^9}, {3.854430203830633*^9, 3.854430219131062*^9}, {
   3.8601385420212803`*^9, 3.860138638056221*^9}, {3.8601386828025064`*^9, 
   3.860138692836401*^9}, {3.8619498070714016`*^9, 3.861949810669832*^9}, {
   3.864111368481957*^9, 3.864111381547614*^9}, {3.8641119129600077`*^9, 
   3.864111933466826*^9}, {3.86411198099782*^9, 3.8641120377855062`*^9}, {
   3.864112243724079*^9, 3.8641122604900866`*^9}, {3.864112766219705*^9, 
   3.86411278769474*^9}, {3.8641135528767495`*^9, 3.8641135674698086`*^9}, {
   3.8641136364748583`*^9, 3.8641136872689133`*^9}, {3.864115609508887*^9, 
   3.864115696314577*^9}, {3.864115732636894*^9, 3.864115830964185*^9}, {
   3.8641158807267537`*^9, 3.8641158812495947`*^9}, {3.8641159142672977`*^9, 
   3.864115966691824*^9}, {3.8641160299919057`*^9, 3.8641160563528504`*^9}, {
   3.8641161004319696`*^9, 3.8641161468625154`*^9}, {3.8641161798404274`*^9, 
   3.8641161881638513`*^9}, {3.864116300781921*^9, 3.864116303316224*^9}, {
   3.864117598850899*^9, 3.864117610456077*^9}, {3.864117641542405*^9, 
   3.8641176697889366`*^9}, {3.864180413527955*^9, 3.864180439734521*^9}, {
   3.8641804809675617`*^9, 3.8641805484890027`*^9}, {3.864439294957782*^9, 
   3.8644393039048176`*^9}, {3.8644393915786576`*^9, 3.864439422827739*^9}, {
   3.864439453939878*^9, 3.864439469354518*^9}, {3.864439507094865*^9, 
   3.864439508154552*^9}, 3.8644397191828737`*^9, {3.8644398454503803`*^9, 
   3.8644398477143235`*^9}, {3.8644399339387035`*^9, 3.86443994606491*^9}, {
   3.886064903615081*^9, 3.8860649365245705`*^9}, {3.8860649824235754`*^9, 
   3.886065042163972*^9}, {3.8860654296691275`*^9, 3.8860654298245497`*^9}, {
   3.8860658521704564`*^9, 3.886065874983266*^9}, {3.886066040165041*^9, 
   3.886066041373247*^9}, {3.8860666771353765`*^9, 3.8860666867852397`*^9}, {
   3.887182510322879*^9, 3.887182533881962*^9}, 3.887182594924156*^9, {
   3.888309810352276*^9, 3.8883099090736856`*^9}, 3.888309979546259*^9, {
   3.889001517107656*^9, 3.889001521496806*^9}, 3.8890015518214397`*^9, {
   3.8890016534686737`*^9, 3.8890016557649727`*^9}, {3.8890018189941072`*^9, 
   3.8890019390049477`*^9}, {3.889001975497669*^9, 3.889002071551203*^9}, {
   3.88908017920782*^9, 3.8890801792936077`*^9}, {3.8890803042138767`*^9, 
   3.8890803393388777`*^9}, {3.889080399346223*^9, 3.88908039943169*^9}, {
   3.889080432285198*^9, 3.88908043295632*^9}, {3.8890805058626204`*^9, 
   3.889080523792141*^9}, {3.8890805689399967`*^9, 3.88908063626715*^9}, {
   3.889080678277158*^9, 3.889080691158598*^9}, {3.889080803941393*^9, 
   3.889080811995376*^9}, {3.8890808810469437`*^9, 3.889080901180773*^9}, {
   3.889080979216024*^9, 3.889080999782426*^9}, {3.8890813330369587`*^9, 
   3.889081473443778*^9}, {3.889081541759335*^9, 3.8890816493962383`*^9}, {
   3.8890817114954777`*^9, 3.88908172105647*^9}, {3.8890843321238613`*^9, 
   3.889084359480877*^9}, {3.902048271131276*^9, 3.9020482784289107`*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"ccb04c64-cfac-4dcb-b945-caef09e3f7b0"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lgk4VOsfx8fS2Blmn7GNQZay71f3uFFJKVeKf0QprcrWciOtFEolKgmF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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-7.295517004712021, -27.263004775487694`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-25.328436022934504`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
          TraditionalForm], {0.01, 0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-29.933606208922594`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-23.025850929940457`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-25.328436022934504`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-20.72326583694641, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-29.933606208922594`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-27.631021115928547`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-23.025850929940457`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}}, {{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{498.73046875, Automatic},
  LabelStyle->{FontSize -> 18, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-7.295517004712021, 
   2.302585092994046}, {-27.263004775487694`, -0.010419437154342952`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.889002010103619*^9, {3.889002048743997*^9, 3.8890020607966843`*^9}, 
   3.889060281076693*^9, 3.889064554959045*^9, 3.889080109628345*^9, {
   3.889080334272502*^9, 3.8890803406419153`*^9}, 3.8890804001464043`*^9, 
   3.8890804336438313`*^9, 3.8890805262295322`*^9, {3.889080570745016*^9, 
   3.889080637481906*^9}, {3.889080681845907*^9, 3.8890806917465143`*^9}, {
   3.8890808090608883`*^9, 3.889080812799999*^9}, {3.889080881737143*^9, 
   3.889080901787978*^9}, {3.889080980578001*^9, 3.889081001418297*^9}, 
   3.8890813818351173`*^9, 3.8890816263012667`*^9, 3.889081657363613*^9, 
   3.889081786692127*^9, 3.889084371125387*^9, 3.889499987326635*^9, 
   3.9020482954284253`*^9, 3.9060157666853423`*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"cdd20bd3-2f84-4cfd-ad8a-6627a7493a28"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lgs4VHkfx2cY4zoZM8Pc3AaD5H6phA5LF2VLl8VGtGF5o22F7aZiVxdJ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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-7.295517004712021, -21.444908691290983`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-20.72326583694641, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {-22.33270374938051, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-21.927238641272346`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-21.639556568820566`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-21.416413017506358`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-21.234091460712403`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-21.079940780885142`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-20.94640938826062, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-20.82862635260424, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-20.72326583694641, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-13.815510557964274`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-22.33270374938051, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-21.927238641272346`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-21.639556568820566`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-21.416413017506358`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-21.234091460712403`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-21.079940780885142`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-20.94640938826062, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-20.82862635260424, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-18.420680743952367`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-16.11809565095832, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-11.512925464970229`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}}, {{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{498.73046875, Automatic},
  LabelStyle->{FontSize -> 18, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-7.295517004712021, 
   2.302585092994046}, {-21.444908691290983`, -0.010328378447827552`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.889002010103619*^9, {3.889002048743997*^9, 3.8890020607966843`*^9}, 
   3.889060281076693*^9, 3.889064554959045*^9, 3.889080109628345*^9, {
   3.889080334272502*^9, 3.8890803406419153`*^9}, 3.8890804001464043`*^9, 
   3.8890804336438313`*^9, 3.8890805262295322`*^9, {3.889080570745016*^9, 
   3.889080637481906*^9}, {3.889080681845907*^9, 3.8890806917465143`*^9}, {
   3.8890808090608883`*^9, 3.889080812799999*^9}, {3.889080881737143*^9, 
   3.889080901787978*^9}, {3.889080980578001*^9, 3.889081001418297*^9}, 
   3.8890813818351173`*^9, 3.8890816263012667`*^9, 3.889081657363613*^9, 
   3.889081786692127*^9, 3.889084371125387*^9, 3.889499987326635*^9, 
   3.9020482954284253`*^9, 3.9060157672824535`*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"51f87ca9-45e3-451f-b17c-cbdbbcec9e4b"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lXk0VX0Xx6/pcjOda3bNRCpRSkU4V5rwVjJEGpRUSlJpkIhKhQazzEmF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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-7.2705523451534315`, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{Automatic, Automatic}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], 
      Charting`ScaledFrameTicks[{Log, Exp}]}}, {{
     Automatic, Automatic}, {{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{498.73046875, Automatic},
  LabelStyle->{FontSize -> 18, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-7.2705523451534315`, 
    2.2795592420641055`}, {-4.140781528789967, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], Automatic}]], "Output",
 CellChangeTimes->{
  3.889002010103619*^9, {3.889002048743997*^9, 3.8890020607966843`*^9}, 
   3.889060281076693*^9, 3.889064554959045*^9, 3.889080109628345*^9, {
   3.889080334272502*^9, 3.8890803406419153`*^9}, 3.8890804001464043`*^9, 
   3.8890804336438313`*^9, 3.8890805262295322`*^9, {3.889080570745016*^9, 
   3.889080637481906*^9}, {3.889080681845907*^9, 3.8890806917465143`*^9}, {
   3.8890808090608883`*^9, 3.889080812799999*^9}, {3.889080881737143*^9, 
   3.889080901787978*^9}, {3.889080980578001*^9, 3.889081001418297*^9}, 
   3.8890813818351173`*^9, 3.8890816263012667`*^9, 3.889081657363613*^9, 
   3.889081786692127*^9, 3.889084371125387*^9, 3.889499987326635*^9, 
   3.9020482954284253`*^9, 3.9060157681847343`*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"83368012-51f3-43dd-aa4d-75e23d01a61c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "convert", " ", "mu_x", " ", "and", " ", "sigma_x", " ", "vs", " ", "mu", 
    " ", "and", " ", "sigma"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"EstimateMu", "[", 
     RowBox[{"mux_", ",", "sigmax_"}], "]"}], ":=", " ", 
    RowBox[{"1.", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"mux", "^", "2"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"mux", "^", "2"}], " ", "+", " ", 
         RowBox[{"sigmax", "^", "2"}]}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"EstimateSigma", "[", 
     RowBox[{"mux_", ",", " ", "sigmax_"}], "]"}], ":=", 
    RowBox[{"1.", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Log", "[", 
       RowBox[{"1", " ", "+", " ", 
        RowBox[{
         RowBox[{"sigmax", "^", "2"}], "/", 
         RowBox[{"mux", "^", "2"}]}]}], "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"EstimateMu", "[", 
    RowBox[{"250", ",", "10"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateSigma", "[", 
    RowBox[{"250", ",", "10"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateMu", "[", 
    RowBox[{"300", ",", "205"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateSigma", "[", 
    RowBox[{"300", ",", "205"}], "]"}]}]}]], "Input",
 CellLabel->"In[96]:=",ExpressionUUID->"f59751bb-bd6c-4cae-9851-1a4226146c36"],

Cell[BoxData["5.520661557180397`"], "Output",
 CellChangeTimes->{3.906015768670044*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"937579c3-e20e-4c7f-b11c-af47d9c31b80"],

Cell[BoxData["0.039984013851751724`"], "Output",
 CellChangeTimes->{3.906015768679306*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"27806da8-4279-43e9-a922-b3a2dae493f8"],

Cell[BoxData["5.512191660524835`"], "Output",
 CellChangeTimes->{3.906015768685317*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"4cb789d9-4655-49af-a847-7642ce402980"],

Cell[BoxData["0.6190166623466058`"], "Output",
 CellChangeTimes->{3.906015768693364*^9},
 CellLabel->
  "Out[101]=",ExpressionUUID->"56122980-fd03-44b0-af02-c1d561e6d9dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotFormFactors", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"qlist", ",", 
         RowBox[{"P11", "[", 
          RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
       "\[Transpose]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "1"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "1"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "10"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "10"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "100"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "100"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "100"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "250"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "50000"}], "}"}]}], "}"}]}]}], 
     RowBox[{"(*", 
      RowBox[{",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "250"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10000"}], "}"}]}], "}"}]}]}], "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "1"}]}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks2", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\"\
,FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Monodisperse\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 1 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
100\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 10 & \!\(\*SubscriptBox[\"\[Sigma]\
\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = 250\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"{", "Black", "}"}]}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<FormFactors_R250_L10.pdf\>\""}], "}"}], "]"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotFormFactors", ",", " ", 
     RowBox[{"ImageSize", " ", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", " ", "cm"}], ",", " ", 
        RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.9042103076855044`*^9, {3.906016083889439*^9, 3.906016098283078*^9}, {
   3.906016138523397*^9, 3.9060161541216483`*^9}, {3.9060161892709813`*^9, 
   3.9060162458132367`*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"f2ddb865-f2cf-400a-84b0-938fe3862f71"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4302.21474091715`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 111, 27, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015779164017*^9, 3.906016212511138*^9, 
  3.9060162533516483`*^9},
 CellLabel->
  "During evaluation of \
In[111]:=",ExpressionUUID->"8d1f3ab5-5140-4506-905b-f751544f18a2"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4281.030879488564`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 111, 28, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015779164017*^9, 3.906016212511138*^9, 
  3.906016253370717*^9},
 CellLabel->
  "During evaluation of \
In[111]:=",ExpressionUUID->"091fa113-791a-4dc3-8dba-4a6ac8a4d8fe"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4260.060152605499`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 111, 29, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015779164017*^9, 3.906016212511138*^9, 
  3.906016253390581*^9},
 CellLabel->
  "During evaluation of \
In[111]:=",ExpressionUUID->"a8d11861-2790-4b40-a04f-69f3fb2441eb"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 111, 30, 17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015779164017*^9, 3.906016212511138*^9, 
  3.906016253407564*^9},
 CellLabel->
  "During evaluation of \
In[111]:=",ExpressionUUID->"0eb42261-2f57-4901-8244-8101ceaa7860"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJw1lgk4VOsfx8fS2Blmn7GNQZay71f3uFFJKVeKf0QprcrWciOtFEolKgmF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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJw1lgs4VOkfx2fG/TKZYe4jDBnXyG2rTd6ziVVUFl1cui5tJUXSf7uhm7Zt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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw1lgs4lGkbx8c4jfPMOzPGzGBmjBHKIUtF8Txd1qbslrZaSpKOW6nQqvT1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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw1lgs4lGkbx8chwzCaGXN+nWacpdoOKpHnWVLZVijFfjmUDttBKzqttkIH
l9pKhUKlorNPVpuVTs9dEalWJ4QcNjaLtBokCZ/vfd/muuaa673euZ/nfv73
//97X1V45PwV2hwO5+HI9/+/p4eT0vedoWDGWou4JWkUXhLkGBEeTUFJa5lh
7DEKW+YXu0/3pKDT+l/dxKMUbjQIE4rEFOyLeBcWk0rhU+H9zW0tSpgxZWWT
XwqFw24m/3G3QAkn7HvFRskUthCP25ueoAR/vw3zLx6mcENE2eKoQCUk2nVc
UR+icGZJ+DhveyXMkqm/bDlI4VDzQY6qXwEOXkV3z+6nsPmWYy8+PVRAeFnj
lHP7KFxfMeH80wwFTKo47LopkcIn7R//fHGtAkbXLvEXJIzUx6+cG+emgJk6
95KjdlHYrJZjHsRXgNHiprzkuJH6ice7xjfIoa9IU7d++0j9r873uXly6FFI
/9TeSuGQlorUxlg5KFLyrnpsHqmfsWZVoZ8c3mQsVjtEU/h1qq5rkkoOL/qj
ZVfWUfjE+0z+jxoZ+KZNaC5bReHg2S5N7vdl8INWknr9Mgqbnn5xVZoig8x5
9VfTQyhc92ndnvfLZTBnwZzz0wMpfNxfP+iBswwKSwOmzfaj8OLLWY6ZejLw
Ltlz7+ocClM6MwY3VUshVrooPxJTuHZxdYXPRSlEF9yIiZxK4YxrUVk2MVLw
cotIyhpL4f/wjTYNekuhs3dG8Cc1hZUrz8+uVEpBdOj5tDAZhWvuYGVuhwS6
uPo/FvMonC6re7f7lgS2Wu8wFg8q8Q/rN5HgAxLgxJx1dXmvxPKHo49MDpWA
q9+Dv8walPiV6vJyo/ESiCxJbrr8WInTt86c2jIshrtb8vhlRUoc9KLB4NZT
MZSvqPAIPqfECqeY18lnxLDGf1SUT5ISV+82yVsbLYaS6aVFcVuUOK0+N97T
UwzqvPkHa0OUOHDKnABKLIaQlaOq3D1G9k96Y9vdYgLlkR6mh61H6lu39ZcX
mMBrv40Prukq8TEse5yVYAL/iPPnH3ijwIHp+ZlbA00g1H3jqaHbCizTzI2a
b28Czj7lbp1HFbjqu7eejv0iCPrGvtR9nQIfzY6TapeLYHhwYG4tVuBFX5Rt
NRkicMkpK7woVGDJwoKb+WtFsCrRzye1UY4rc30P7nUTgU1Lp/XBy3Kcqte+
ZClfBKc/Fl3dHS3HC8N2T3JpEMLmpl3+P02VY/F1cz1hnhDs7r2qmNkvwy8F
Ra/+iRWC4/KYAb3rMpyyekEO+Amh+26ybdEGGQ6417k9TSWEwzc+nl7hJMNi
KtFvvUYA/IK55mZvpPjlBrXVnPsC0PTM0upLkeLkx7d6LVIEUHy9ZqfQS4oX
2ASW9S0XwERFT85hjQSb7PiQUeEsgGvRB+XZJyX4RdWv6y7oCWBnZOkvW2ZJ
sE3Y93FDV0ZDyAfrRq9OMT4riLe54jcazDWnMryPiLH1vYLyEI0x1J+k9O86
i3H2hvZIfooxbNujP9BRbYKtbCwkt52N4ZnqtiEvxgRnVS24EVHNh7ntVx4H
KUywOjExzDSGDxk8h1GiIhHOcrmt+1jJhz89PARrgkRY3fHh0i+3jKBRv3DH
wT4hPnPC1ndMqBFsWb1Keu6oEKvmLe6pHTaE98VXPB45CzHDK0P4fNJzSFIp
YPlkCG5eVyYd2ShgecQD4aYze7zEApY/PLAdOPFn6KrRLG94sNkm5EnKRWOW
LwaQMj5VSLXxWZ4YgGua4eQ6Bz42pflhAJ793r/fWmOET9C80IcVdU4N53MM
WT7ow65949HOdzyWB1zofWm7x2Usj80/FzrzhN1F6wzYvHPh/CjOmu5cfTbf
enCqaq3Nq04um2c9qNT0eAaP5bL51YPc7MbJmyL02LyOglrft+aKnFFYQedz
FBhmVvq6t+niNDqPuiCN0dyptdXFMjp/ujBsK7jQvEwHH6Pzpgt3VnNdfE5r
s/nSgZ++cV7Oe63F5kkHkuZX/mYk02LzowO26QF2M/05bF60oefUb7HukmHE
5EMbbvMacyQJg4jJgzbES0qnt/QMIAntfy1wnBvitH3pZ8T4XQtE9WMH8x59
Qia0vzngPHVJwpxJfYjxMwd2Z6prjdN6EeNfDhTPJ2al/d3ImvbrMAm+1BE+
IUiDrGh/DpHsZ5p4g9+7kIr24xA5ejv1HV/8HlnS/hskO4uHtxcVtSNL2m9f
SGb/z4nRi1qRBe2vAUJuTEzY39aMzGg/DZBD5w/H+0c3ITPaP5+Jx5FsuW5T
DaJov/STjhzj5Mv3nyML2h/9pHyR98QWqhSZ0374RN6HL4k51PMbMqPn30d6
r1t3u+6+REzpeX8kB9z/mPYipoRQ9Hw/kjNFUx60r35OlPQ8e4lA/vF1vEst
kdPz6yFU7OQZNdK/CDOvbvLHLOFOL+u/CTOfbiI4FzxJOKuNMPPQEN/ezsLv
tncShj8fCL/B4N+4v7sIo3cXcaro4lnJu4mI1reL1F3KniQK7CWMnu9JybK9
B55n9REVrV8nuXB8bkLLQD8xp/XqICe4su/vh38hprQ+7WRBVbpRc/UQUdJ6
tJFYpd3W6lwOyOnzt5Ljsi/Rnn1aIKPP+5YoprevD52jAyb0+VpI7YFBA+8R
n4ro8zSTGVbUXYW2Hgjo/v8iz+ZddahbwwU+3W8T2djypWpvnT4o6P7qyXbu
NrkogAc2dD+1pIO83Ovz0hAs6f2rycSluTs5wXwwpfd7SQarHLZVtxuDkl7/
GSlovj1rIhaAPb3eEyKLqT9mbCwENV1fSgQPxnn9d4TrMvr/d8nmca99LuSL
wIq+X0juLdvvt3/kOWRDX18gT0RtqTXBYuCwn8KATlutyRKwZe4jresqRYSh
FFRMPTLMeaWOfSP9uj4ySxy/7PR1Gbt+KZL5ecncD8hhDNMf6imsvlMZpvja
P5oa6KY9MF4JZsz50ELF0KGQQeXX86OW4edTn5RSX/VBxZu+Pe6aZAoOjH6o
FUkCbi4wAxmjL5pUU71vm8QcFIz+yKE2ZG/pS3OgmPmgxneln3oPW4A5Mz/k
Pe/pkwJbS7Bg5ouii45ll+6yZPVrRRWTxy0Ob7IEBeMPZNPS8vh3NxWw/kHN
Vk/1W9JUwOSxA7U2XJ4t7lUB6z+0eknEjlB/NagZfyKha0ZMZa4aGD50IfM7
Pkv38KyA9TfiLXqSsPFHK2D9j1qX94eeLbYCKZMP9Gj61kMitTWw+UGeb+s4
N2Ktgc0XGn7g9DS53hqY95cepPpWODXN1QbYfKJkt82IpNsAm19084hOgNan
kWsm36gfcc8HLrIFNv8jXMmOuHXNFlg+oPLxUdpjTOyA5Qcyrwr751SUHVgy
fEH5HVEF8qd2oGL4g8w0bz8nj7MHNcMn5O5430p4wB6sGH4h6pf1Cw912IM1
wzdUU1+wUPSdA9gw/EOrSrJ+TrvoALYMH5Fh7OZj1lxHVs8htHSepaBohSOw
fEUbuA8fBRU7AsMHDtbwer25VmOA5TN+9mFabln8GGDeTzj4w98THpxpGgMs
3/HpC5GKNOTE6q+Fj+u61udnOgH7fMBHQ9Le9Q46sfPQxr439+auDRkL/wNO
/91M
         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.2]], 
        LineBox[CompressedData["
1:eJw1lgtYTPkbx6e7piYz00zTzHSby4l1WaTIht+7SqFFFPUP3azNJRJS7Fq1
Utkoq5tCkkVYcmvZxHlp2bLZcqvVzaVsN1K5FcrO/5yz8zzzzPM+v/Oe8/t9
3+/3M0cVFjl/mT6Px6vQff//m/8pLefHQ0r0W7dTX32IgpCAERFh65S41eJ+
c3M+BQ5nf5/6hbsS47uO2+br6kemwSKxRImxH+udFurqg2H9ze0tCgxpWrrf
SFcHX07/9VqxAl3qb5SfOkiBveTzHTmJCvScuVI5R1c3RZQvivJXIOnr6XyW
R0HejbDPZw5X4Bh14vYNujrIboCn6pdj1A6tY/8BCuxisu/1Vcjx+4S2gXW6
urFq3NHqXDluuzvv8yf7KTgwvDK2cJXu+tE/VkzT1UHx33jHTZbj9BMn7mTt
o8C2jmcXIJDjMKm+a0Ourt9pX/eYJmt8lLakQaSrD6S4lJkUWeOFv/x2Tsih
YElLVeajrdZoEL5Pf+ZeXf+Ulcsv+lhj16WAf7yyKWjINHRLU1ljLz/51rgs
CvZ35QnCe2WYuylstFEmBYu9Jj2eWiZDXHE/BtMpsMm/d84qQ4Y5o3gDoXso
qO9bvb3raxn+8kNVf+tuCvbNGxJw00WGXscyM3zSKFh0omBEnrFufUtZQ84u
CpQGUwaia60waUXRrWspFNQtqq2aXWiFMvd15OYOCnIvRBVQm6ww4rc6wyNJ
FAQKzKMHZlph9vzY24u2U6D45qjXA4UVThXSzm0/UPDwKihOdUpx2x4P2iuO
ghxZ/fOEUinmhsrqY7ZQ8L+10fTiXVKMuDP2cfRmCqwrhu5xDpLig8t6IhJD
wd+qE1+bj5GinkSxr3q9rn+zx8SWTxL8RdmZPWwtBQH3mkxLqyVIlx8WfBlB
gXzUpob0QxIcfcaxW76cgtoEy6JV6yT4bbq1umgpBXsbT8W7u0tw9ybjjQNB
FPhPmOGnlEjwL9OCIr1A3fPTnjq+arHEWefF2y/56fpbv+u/VWyJSXqB+XZz
KcgGWWVBoiU+WFyRP3amrj/nbN5mf0uU+CfZdE6jQNbrHTV/uCXyUtUFsyZT
UDPrH/cR/WJMVIwt8XahIOtwnJX+LTG6bXrV1jGagoUfFe0Pc8U44q7gjNaR
AumC4stnV4nRNtFp9xtbCh6cmpu6Y7IYA5838QOlFGQad4SECsSY52L58xxz
ChYEJ4yf1CTCAxv5LVX6FEgu2RmLikRY8uJlQF2fFu4Lf/u7basIg0+m7V3Z
pYWMFb4n0UeEm+t407Y0a8Hv+oste1UibBvw+mTxtxYkymSftb1C9E57mWhT
qetfr9bMKBNi/rbMAwW0FtIrS9/YZwjxoE+ELO+cFnwp//J3XwvRQ3P6odkR
LVh+35Nb5SJEvpleQ1uWFu7VpKw+ZixEg65bnzkla4EK/ipu8PRQhGEbmlti
tfCzMJ467TMUh1zOJoPLtaC9XnxrSa8FBosddn4boIXD6zsiBRkWmDBu7phA
Ly1oKHvpFRcL5C86W5jtooWCGt+SiFoBWpv1/zROowV1cnKwzSYBzhhVdpAS
6tYnXTGsVAhwSOC0gqiPGlB39hz/ttQc176q2m7ZpoFD+x3njgwyR8npUF/T
expQzVn0uu6TGc53fzp23hUNsLwyw19LV4W2H9VwfDJDp6rQ6dVpGo5HfHQp
WBloGKvh+MPH3fM83BKCNRxv+NgdFX1wjqeG44spxjytCQwbpeF4YoqGnm8W
XxVpwIbhhylW5M84E/pWDfsZXgzBEVWwybtOzfFhCJY+ot5svqLmeGCC4Xf/
jH15UM3l3wQfPZFHFsarubyb4KDvN/5HwtRcvo0xpbmw7Nk0NZdnY0ybkLRw
hVrN5dcYc3bCtTF6ai6vRlj+cus110cqkDP5NMKBCjv7hFIV7GXyaIjXH7Uc
F+WoQMbkzxAXr1k48ckGFWQzeTPE0Kwj+b1zVVy+DLBixROcPkLF5ckAi1//
sL7OQMXlxwBNY7amn2lw4PKij+IbFh/+uODA5UMfIWhJgsNOBy4P+mikXGVW
EqZbZ/yvhybq0KgMVwfO73rYfvH8oSKBA1gy/uZhSG69k+x3e87PPHzQKHvq
s8qe8y8PUwwK7pqL7EHL+PUT/aJ+4K13sR1oGH8O0h2nTtQNDbADFePHQXp5
88y7gf224MD4b4A+vtXDeWyOrmb89lG3Xp2TMdEW7Bl/faCdS1OGpd63AVvG
Tx/oBa2N9dq1uprxz3v6TI70cRjfBpSMX/rp+bKgWr/DSrBn/NFPL9TkaPlu
SrBj/NBHv8/8yTbzjgJsmfm/o0XWTvZm4QqwYeb9luYJjq1P+CAHJTPft/Tt
fZJ+ZZocFMw839D6Iakbu1RysGbm95p2M/NIlV+w5ub1ii4btwtKpltz83lF
txyr/9hRI+Pm0Uv3hSR/dS1cxvGnh94WKnH17rPi9O6m/bwu5+9MtgIxo283
nVXr2fydtRWnZxf9rh/GGRVKQcXo94Ke0JNrw5soBTtGr056zYWI6i9uSMCG
0aeD/rJ4WUDsfAkoGD3a6ZWOpaqYJkuwZs7fSmeHr0zqW24JMua8/9B73B9f
regRgyVzvhZaKi5pqowVg5g5TzN9+6aziDcoAiGz/yd0nNRlS1y8CATMfh/T
c6ITgxMNRCBn9tdIN04OOxmQIASK2U8dPWi4/XdXQyE4MM+vpSVp53oyjIeC
DfO8+/SU/KN7eQYWoGDuf4f2fjEsddSAOQxn7neb/vnSPT/P12agZvr/oLPd
UvK2tvJBxlx/jTbXRt+JrDEFDbN+ka74sMHN/9oQoJj6GJ0qFj8THDcBHveZ
bFI5JTnVGBzZdeI5PqlGu84IVGw/CVvn0PGlr+F/9yeXxcLirLEG3P3/IIOO
fUvdTfVhJLs/MlGxfPfVRt5/+ychny3r5gd/Irbs+cjxwvS27sGPhDs/mVVu
9suYnPeE04fU2osXuI7oI5+x+pG5b+cYys69ITJWX3LVt9Koy/kVkbP6k1q/
cpfJF7qJkp0PabQp+DTd/zmxY+dHvru9I4Y4tRJ7dr5kz5+C59cNnhJWv1YS
OveUoe/+h0TO+oNESx5n90j+Ipx/SKnVpPqVq88SNo+d5PzTC+gZ9RvN+Y/8
Os7ZyMn1Dq1m/Umei4rap49poFk+dJPk1j1xk7Kbac7fpHrelIy4ke00539i
9mGq5GFZF23F5oNE6m9sVbn00lx+yGG7q7PSBW9oLl+kbv2g6l77O5p9f3lN
6m3W/Lih8j3N5ZOM/DA/3uvcAM3ll1Q9PbfNdw4PWZ7r6tfnQgNv6iGXfxLR
eefQ7KkGyPGBLJ42pGt3iSFy/CDD+cdCH0wwRgeWL8Tztcfbk+dNUMXyh0wt
t3pn6WyKapZP5ABvScKxYj5qWH6RMye/L1w6wRy1LN/Isv0LZ7teFCDF8o8M
r0kLWDRpKDqyfCTDzKduiw0SIqvnIEmxWB2JDiLk+Er0U5sT3JpFyPKBB2vG
b5bkHhEjx2coCTq6IyFc957F8hseZB8e/2y4BDm+Q3T46erEDgmy+uvB4r0+
kQGnpMj9P8BsEmmcEGmF7Dz0ISRiFz9krAz/Bd6esNI=
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -28.110132790371527`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> {
       GrayLevel[0]}, FrameTicks -> {{{{
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "13"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000000000000000], \
-299.33606208922595`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-
           Log[100000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000], \
-294.7308919032379], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000000000000000], \
-290.12572171724975`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000000000], \
-285.5205515312617], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000], \
-280.9153813452736], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000000000], -276.3102111592855], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000], -271.7050409732974], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000], -267.09987078730927`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000], -262.4947006013212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000], -257.8895304153331], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000], -253.28436022934503`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000], -248.67919004335693`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000], -244.07401985736885`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000], -239.46884967138075`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000], -234.86367948539265`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000], -230.25850929940458`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000], -225.65333911341648`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000], -221.04816892742838`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000], -216.4429987414403], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000], -211.8378285554522], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000], -207.2326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000], -202.62748818347603`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000], -198.02231799748793`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000], -193.41714781149983`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000], -188.81197762551176`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000], -184.20680743952366`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000], -179.60163725353556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000], -174.99646706754748`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000], -170.39129688155938`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000], -165.78612669557128`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000], -161.1809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000], -156.5757863235951], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0], -151.970616137607], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000000000000000]\
, -147.36544595161894`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000], \
-142.76027576563084`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-
           Log[1000000000000000000000000000000000000000000000000000000000000],\
 -138.15510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000000000], \
-133.54993539365464`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000], \
-128.94476520766656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000000000], \
-124.33959502167846`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000], \
-119.73442483569038`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000], \
-115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000], \
-110.52408446371419`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000], \
-105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000], \
-101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000], -96.70857390574992], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000], -92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000], -87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000], -82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000], -78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000000], -73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000000000], -69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000000000], -64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000], -55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000], -50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000], -41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000], -36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000], 23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000], 27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000], 32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000], 41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000], 46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000], 55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000], 59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000], 69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000], 73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000], 78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000], 82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000], 87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000], 92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000], 
           96.70857390574992], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000], 
           101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000], 
           105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000], 
           110.52408446371419`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000000000], 
           115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000], 
           119.73442483569038`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000000000], 
           124.33959502167846`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000000000000000000000], 
           128.94476520766656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000000000], 
           133.54993539365464`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000000000000000],
            138.15510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000000], -29.240459028362647`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 3]], -28.834993920254483`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000000], -28.547311847802703`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000000], -28.324168296488494`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000000, 3]], -28.14184673969454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 7]], -27.98769605986728], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000000], -27.85416466724276], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 9]], -27.736381631586376`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000000], -26.937873935368604`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 3]], -26.53240882726044], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000000], -26.244726754808656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000000], -26.021583203494448`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000000, 3]], -25.839261646700493`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 7]], -25.685110966873236`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000000], -25.551579574248713`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 9]], -25.43379653859233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000000], -29.240459028362647`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 3]], -28.834993920254483`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000000], -28.547311847802703`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000000], -28.324168296488494`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000000, 3]], -28.14184673969454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 7]], -27.98769605986728], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000000], -27.85416466724276], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 9]], -27.736381631586376`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000000], -26.937873935368604`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 3]], -26.53240882726044], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000000], -26.244726754808656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000000], -26.021583203494448`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000000, 3]], -25.839261646700493`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 7]], -25.685110966873236`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000000], -25.551579574248713`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 9]], -25.43379653859233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 
      2.302585092994046}, {-28.110132790371527`, 10.814712600368843`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Monodisperse\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 1 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 100\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 250\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.2`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.906015781610222*^9, 3.906016215008806*^9, 
  3.906016255235463*^9},
 CellLabel->
  "Out[111]=",ExpressionUUID->"729e95fa-2829-4d9a-aeb5-4804aac10751"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\FormFactors_R250_L10.pdf\"\>"], "Output",
 CellChangeTimes->{3.906015781610222*^9, 3.906016215008806*^9, 
  3.906016261564968*^9},
 CellLabel->
  "Out[112]=",ExpressionUUID->"91493871-f28d-44bc-85c2-b07de19d6b67"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotSlopes", " ", "=", " ", 
  RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"slope", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"P11", "[", 
           RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
        "\[Transpose]"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "100"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "100"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "250"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "250"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", " ", "0"}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Monodisperse\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 1 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
100\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 10 & \!\(\*SubscriptBox[\"\[Sigma]\
\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = 250\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<FormFactorsSlopes_R250_L10.pdf\>\""}], "}"}], "]"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotSlopes", ",", " ", 
     RowBox[{"ImageSize", " ", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", " ", "cm"}], ",", " ", 
        RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.9042103161180873`*^9, {3.906016300484651*^9, 3.9060163028406496`*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"ad10af04-9d62-4a8c-bd41-9f9ed35934cd"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4302.21474091715`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 113, 31, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015799392209*^9, 3.906016312916642*^9},
 CellLabel->
  "During evaluation of \
In[113]:=",ExpressionUUID->"e250c419-bd3d-4f1c-8e0d-dbd20786bc8b"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4281.030879488564`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 113, 32, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015799392209*^9, 3.906016312935182*^9},
 CellLabel->
  "During evaluation of \
In[113]:=",ExpressionUUID->"1a9bfc75-1d42-4578-a14c-39c2a4800593"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4260.060152605499`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 113, 33, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015799392209*^9, 3.906016312950816*^9},
 CellLabel->
  "During evaluation of \
In[113]:=",ExpressionUUID->"5d50cc9e-04b0-482d-8a8d-050de331ee4d"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 113, 34, 17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015799392209*^9, 3.9060163129687877`*^9},
 CellLabel->
  "During evaluation of \
In[113]:=",ExpressionUUID->"1a6fd400-0c23-4754-a2a6-e47bae0a4cdf"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJwdknk8FAgfxucyjIZmzLjG8rIhq4PVSsqRFNG6ybmUaFWkUqHIkQ4RWzvK
OWuVKFG5FX6/WMeK6ELWOEqEFmFyjnm97/P5PJ/n8/3j+ef3e9R8gx39SQQC
IWbV/0vCRn7st3glTJHRv2zicQswLtTlpYcSPujMcbCLTYVoPlPr3gYlNBt3
LM/pTwfTrQ8XI5c5GGFn/M0zNAtESRZtLm0cfN7iwE1anw0wMvDHJh4HzVRb
KuPL/4QLO8+fEgvm4GR3vR4p8A6YpMnu4Zty0FxY61G0LxdWvj6SL2NwUCrR
Ri3bPQ9qra3HEgcVcUt7FN8m/T5cuDNU7VesiOIXLaYzZB6C8fKFZKOLisiL
KvUeaSqCFWdFX7azIvpP7s+TGHgMtYUlP31RV8T7T3MHG6KLIZJqK/6XQAFP
iK+UlViVgrHP5/cZjQpoQUnzf2JSDsKK2IchtxVw9P7Ng8JDlVDDUI7aF6CA
VcGHnU1qn0LEkQqHdYYKyPazXEl0rAGjOgf1JZoCLt7Ye86UhbDM+fLtdY88
xv/sra2Y/RyqQy7//aBAHosIUcabnOoholU1MzZCHkfE+z9p6jbADo1nxz1s
5JF3KtNWckcTLEW6mOmpyKPG7Zxco7C/4VnnJEtyUg59+bSaxC8v4JzOteFB
kEORVcAuo6yXsP2qelXVb3JIfOleR2nugMWB2oQbB+WQtPNkb6b/a3hq6O59
RE8Ow0KLO15pv4VzN2d0zchyWPGpRP8XpU4wHL9OVnwri5Gj+01+3tENC+Za
nVN3ZXE2NugTJbkHKjPr8pvPyOKYa+NNayU+hAm8zmdbyGJLGrvN7FM/bLOd
swmTl8WmtsHNhuGDMH/vhqr9ZzbylM9fOqT+ESpFG2bWV7HRwga7d88NQZhb
Y4Mono1HDfTFNgmGYduTA6ldHmzck/mXZ5LaKMzTlo4+2sDGjN3DvMmocaj0
TTG+sszCpBCyaidrAsKe6TB82liYVU/3djwxBQbslg9beSy0aWdnlM1+hblA
vzLpYBb2Zar326XOQEXDypXh1cf8e5mowvcUwFmVNI9aBgsVyzuZTqZzsDV0
y6ZbgzKY+5GrecFsAb61t4mCimXw+JbioHCfJSjXCni956IMas9rhs/9LoQz
MaRcZWcZdPE6XeLYKQL9nsxQgboMNpZtTHhMJ6JAz8C6TcDEH6rNRZIaJCxN
ePVdbiMTX8ixyqTXk/H00LHJiNtMtOJ6xAcSKfiTMbXOOYCJTcssmQYeBWdT
srkbDZnoPq+rPD9MwdKJ7b9SJJnoRe2+GlNHwdOW7wx7exg4obH+zFXV1X52
ML20gIFiWjr8fSISzszT+hMiGJhk29PBO03EEoe7Tw7ZMDBNrtSP6CeCkAcm
cTtUGJgen5ntL1qCw9TiQs2+tXjFvkE3w3MBhiqGHTuj1iLzwOdFb8I8+B1R
mr+kthbJDU4l4dvnYYhjn6VfL42+FbvGQ2iLcKg1btcnP2n0J5ryy74TwofI
qhEuVRotiTotIYEE9NWZSNydL4WPx9UqzX4k4YeB7/VmraTQ0EALuZ5k9L3p
2nVnnI57jLbYip0l4wfzxAin63TsC3LPN7Mn4UEBqpF16Pg18cN1fxMCDtwT
NBZ3rMHBtoKm8+bLcMBNO9D31Bpcd2n/3grmIgzQfJgy7DVop8oV0jWXwOfZ
7+XPyyRxfdK+Ziu6CPoCmz1Pukri1V0txQWvieitIiSoLdDw7OaBpWkSGfva
f7zXkU7Dq9ka1/KVSOgVc3hftBENIxruPZtxEEGvXsaUTp8EDs7svU1LXgKv
ofaU/igJ3BN8eLQ8Zxl6Uyg7ktUk8NXKRAS7i4BeloYDJvXiqC9X429STsLe
+aBLE37iSE74WJSfR0TPBznaPKo4DmdvzfryXgg9nl3tNvlUtBjgeHH6lsFD
in5GaEVF/pjoisLqvnpqd3IKx8Uw7cWIOvcOCd1PnAGv62LYXUMWe3qUgN1q
D/zoOmKoFU73dnUVgtubPlp1BwXHjeI08zlE7IpjPTp2ioLJ6eotr+JJ6LZ1
r7MSm4LRBLHtUSki6B6JWGgpI6MEkanrMSkC17QnvHOuZDQjhFX5V5Gw03rY
XHuBhKPSRSE7bxBw/zJn9H06CWvtT7gt+hPwXaFdUrzR6t2aVK+oDpPQxSdu
i2EfESViW8latgR8y6jq/hxFRM7lWvtfdEnoXPdvZKoaEfMSq/ynxUj4JuT7
dXvrCUi1FKdUHCGik4Zr85wfAaPrzlaNMsn4ujMhKI9KwNizuyMDUoh4lxGj
UWQvApOXk3VrLpIxJ2QsWIq7Apy8OqqeNwmzO52eBnYJ4TfW54niZDJmG9ZQ
WjlCeFfMNwtoX+VMTbsN3stgNCVpetCFjDxRctq1P5dgqZy3LURDDLN8Fz6O
Di2CdUCBweEsCmY2+G620loEi0tZb472UjBLqzUs/9gC1DeH3nK1piIvQb9e
/NE8ZMTdMEr4uMoTPKlfp+fA2VmjuFZWHDMdJNwa9edAU6Vhv1nJKpeezNEI
/waylullzCIJTJf/50tctQA2+hpfLGygYdq53QZDolnouh74dWJMElP5hTHm
5rPww9xSuGgzHVN3yrfmXJ6BtLC1ynoFUnjrTrQcqWUaYhvDy5WPrUUudezA
QalpeClgrYRnMZB7xKkA7b+C8elGZw8/Jt5srRb8hzsFmyecFZXiZDBDrel4
nvgUEP4vNv4XpY0cvg==
         "]], 
        LineBox[{{-0.15897359698658403`, 
         0.}, {-0.11512925464970238`, -1.6287746525129954`}, \
{-0.0690775527898214, -3.47315360659058}, {-0.037921523974685165`, -5.}}], 
        LineBox[{{0.4181125955120058, 0.}, {
         0.43749116766886903`, -2.2035933738520566`}, {
         0.4592548101070294, -5.}}], 
        LineBox[{{1.0300566618934435`, 0.}, {
         1.0361632918473205`, -2.7912051877389294`}, {
         1.0405805788006257`, -5.}}], 
        LineBox[{{1.4030544629840807`, 0.}, {
         1.404576906726368, -2.0079076160471723`}, {1.406616190220153, -5.}}], 
        LineBox[{{-0.4630091954351677, -5.}, {-0.45558763115351936`, 0.}}], 
        LineBox[{{0.228351298675993, -5.}, {0.23165559146828285`, 0.}}], 
        LineBox[{{0.6388805057950484, -5.}, {0.6418271126351097, 0.}}], 
        LineBox[{{0.7712896436868366, 0.}, {0.7913156694506129, -5.}}], 
        LineBox[{{0.9206531506765594, -5.}, {0.922823593514723, 0.}}], 
        LineBox[{{1.148580701936892, -5.}, {1.1506253823231076`, 0.}}], 
        LineBox[{{1.232974324436615, 0.}, {1.2404666107865674`, -5.}}], 
        LineBox[{{1.3325406971710336`, -5.}, {1.3345793895516362`, 0.}}], 
        LineBox[{{1.4747166083386538`, -5.}, {1.476581691130728, 0.}}], 
        LineBox[{{1.5454662411386455`, 0.}, {1.5483748203367542`, -5.}}], 
        LineBox[{{1.6118059464218635`, -5.}, {1.6134630565154207`, 0.}}], 
        LineBox[{{1.6728481717421073`, 0.}, {1.675795498224752, -5.}}], 
        LineBox[{{1.7423368266672223`, -5.}, {1.7475824435325478`, 0.}}], 
        LineBox[{{1.784443588757234, 0.}, {1.786808128178082, -5.}}], 
        LineBox[{{1.8414204048096063`, -5.}, {1.8430619614124528`, 0.}}], 
        LineBox[{{1.8846481089094325`, 0.}, {1.8861050511640203`, -5.}}], 
        LineBox[{{1.933963364019762, -5.}, {1.9352909742520752`, 0.}}], 
        LineBox[{{1.9838264927609561`, 0.}, {1.985440323567661, -5.}}], 
        LineBox[{{2.026707434680225, -5.}, {2.02883324280162, 0.}}], 
        LineBox[{{2.084133064413623, 0.}, {2.0877508433225147`, -5.}}], 
        LineBox[{{2.1569101102114057`, -5.}, {2.1610871000057172`, 0.}}], 
        LineBox[{{2.2126654353104493`, 0.}, {2.2166588091265904`, -5.}}]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJwdU3k8FPoenRljGEvNxjBzU7IkFI9UUynRIp4tinCt00JK5cpOuSprqitb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         "]], 
        LineBox[{{-0.45070233049761577`, -5.}, {-0.43749116766886864`, \
-3.340119364548506}, {-0.40916589123633906`, 0.}}], 
        LineBox[{{-0.15835635919293262`, 
         0.}, {-0.11512925464970238`, -1.3635336400934759`}, \
{-0.0690775527898214, -2.875114550368227}, {-0.02302585092994047, \
-4.353574220288684}, {-0.004264274086173737, -5.}}], 
        LineBox[{{0.24842256704529578`, -5.}, {
         0.25328436022934525`, -4.545627700351357}, {0.29731791676165814`, 
         0.}}], 
        LineBox[{{0.40754317805681534`, 0.}, {
         0.43749116766886903`, -1.4688377817191596`}, {
         0.48354286952875003`, -3.9577792002685275`}, {
         0.5049569916251841, -5.}}], 
        LineBox[{{0.6551586273159189, -5.}, {
         0.6677496769682738, -4.232386627862606}, {
         0.7138013788281548, -1.6827892329668246`}, {
         0.7598530806880354, -1.497584951654672}, {
         0.8059047825479155, -3.0179807600688653`}, {
         0.8519564844077967, -4.635981757674834}, {0.8739163901698618, -5.}}], 
        LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAPMtS4i367T8AAAAAAAAUwCIlHxW9
Ne4/tHdyolWzE8AlX0yA/q7vP9o6/pA/iw3Ak8y89R+U8D/K4VYOqKsJwJRp
U6vAUPE/Z3QXq9vdDcCVBupgYQ3yPzAD9qgpsRDAlqOAFgLK8j8OAQWt+N4Q
wJhAF8yihvM/i4OMT5psEMCY3a2BQ0P0P+BXoyPliw/AmnpEN+T/9D9dcH9u
bUQPwJoX2+yEvPU/sGnn3l97EMCbtHGiJXn2P8d5l/G1UhDAnFEIWMY19z9T
t9gT4PoOwJ7ung1n8vc/xrAtzyTBD8CeizXDB6/4Pxdr5roxeg/AoCjMeKhr
+T9MdFMWNTwPwKDFYi5JKPo/vHHuQkxaEMCiYvnj6eT6P4/d3MAgmxDAov+P
mYqh+z/jmmjTlnwPwKScJk8rXvw/J4tGz7DzDsCkOb0EzBr9P/o0ZHKshRDA
ptZTumzX/T+0Z0p5V6YQwKRz6m8NlP4/81fXoQH7D8CjEIElrlD/P5iEmGLT
9w/A0taLbacGAEC1SWc9McYPwFIlV8j3ZABAK9tOehkbD8DUcyIjSMMAQJ+L
8vdBnw/AVMLtfZghAUCYLAIPIKcQwNQQudjofwFA9KYYMg9gEMBUX4QzOd4B
QCnxHwM2rg7A1q1Pjok8AkA9h2ATWzgNwPNN8lQ=
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw1lXk0VW0bxs9gOqazz3E4hshUGdNgSKl9vBo0SSJSIYoSDSQlhLxKEgoh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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw1lXk0Vesbx88xHNPh7GOepySF62aqY9q6KjJk7KaIopIi0aBCEU2arqgo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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.2]], 
        LineBox[CompressedData["
1:eJw1lnk4VO0bx8dgGGYYjG1oRNGmtEmUjkKbt7KVpUSSaJPkJYk2VJKS7FuS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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 2.302585092994046}, {-5., 0.}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Monodisperse\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 1 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 100\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 250\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.2`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.9060158028357043`*^9, 3.906016314965288*^9},
 CellLabel->
  "Out[113]=",ExpressionUUID->"80bb1403-1c4e-48e1-9783-bf8fd5504e7c"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\FormFactorsSlopes_R250_L10.pdf\"\>"], "Output",
 CellChangeTimes->{3.9060158028357043`*^9, 3.906016315870757*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"78569c7d-162d-49f7-803a-c5c82cd19ed0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotSlopes", " ", "=", " ", 
  RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"P11", "[", 
            RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
         "\[Transpose]"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"slope", "[", 
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"10", ",", "1"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"10", ",", "1"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"250", ",", "10"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ","}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "100"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "100"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "250"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "250"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", " ", "0"}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ","}], "*)"}], 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
          RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
          ",", " ", 
          RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
          ",", " ", 
          RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ","}], "*)"}], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "8"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"(*", 
       RowBox[{
       "\"\<Monodisperse\>\"", ",", " ", 
        "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 1 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ","}], "*)"}], " ", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
100\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 10 & \!\(\*SubscriptBox[\"\[Sigma]\
\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = 250\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<FormFactorsSlopesNoMonodisperse_R250_L10.pdf\>\""}], "}"}], "]"}], 
   ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotSlopes", ",", " ", 
     RowBox[{"ImageSize", " ", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", " ", "cm"}], ",", " ", 
        RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9060163130946445`*^9, 3.906016333049883*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"48a44b2d-5a2c-4c89-9786-d0ed942db9eb"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"3284.088728164614`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 115, 35, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015804571931*^9, 3.9060163352006598`*^9},
 CellLabel->
  "During evaluation of \
In[115]:=",ExpressionUUID->"67a8287c-709d-47bc-8a6d-b0b7d5342d1e"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"3283.1661047079383`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 115, 36, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015804571931*^9, 3.9060163352122173`*^9},
 CellLabel->
  "During evaluation of \
In[115]:=",ExpressionUUID->"387b0686-5582-4505-b2e3-45cfce5846ab"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"3282.252985264404`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 115, 37, 
   17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015804571931*^9, 3.906016335222722*^9},
 CellLabel->
  "During evaluation of \
In[115]:=",ExpressionUUID->"71e9fdce-e825-4326-b63e-07de7691ed1f"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 115, 38, 17050716133839058357, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.906015804571931*^9, 3.9060163352389846`*^9},
 CellLabel->
  "During evaluation of \
In[115]:=",ExpressionUUID->"4bda31ff-5d69-4bfd-ae65-03225756b935"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw1lXk0VW0bxs9gOqazz3E4hshUGdNgSKl9vBo0SSJSIYoSDSQlhLxKEgoh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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw1lXk0Vesbx88xHNPh7GOepySF62aqY9q6KjJk7KaIopIi0aBCEU2arqgo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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.2]], 
        LineBox[CompressedData["
1:eJw1lnk4VO0bx8dgGGYYjG1oRNGmtEmUjkKbt7KVpUSSaJPkJYk2VJKS7FuS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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 2.302585092994046}, {-5., 0.}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 100\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 250\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.2`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.90601580709789*^9, 3.9060163363418865`*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"c9f4fe1c-0fa3-47fa-b504-e3448df9cf67"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\FormFactorsSlopesNoMonodisperse_R250_L10.pdf\"\>"], \
"Output",
 CellChangeTimes->{3.90601580709789*^9, 3.9060163370657396`*^9},
 CellLabel->
  "Out[116]=",ExpressionUUID->"156f324a-97d0-4923-a6e7-87b79039a71c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plotFormFactors", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
        RowBox[{"EstimateMu", "[", 
         RowBox[{"10", ",", "10"}], "]"}], ",", 
        RowBox[{"EstimateSigma", "[", 
         RowBox[{"10", ",", "10"}], "]"}], ",", 
        RowBox[{"EstimateMu", "[", 
         RowBox[{"250", ",", "250"}], "]"}], ",", 
        RowBox[{"EstimateSigma", "[", 
         RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "5"}]}], ",", " ", 
         RowBox[{"10", "^", "3"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks2", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\"\
,FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
        "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
        "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Monodisperse\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 & \
\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = \
10\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 10 & \!\(\*SubscriptBox[\"\[Sigma]\
\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = 100\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 10 & \!\(\*SubscriptBox[\"\[Sigma]\
\", StyleBox[\"R\",FontSlant->\"Italic\"]]\) = 250\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellLabel->
  "In[108]:=",ExpressionUUID->"6d91c493-1444-458a-a1c2-88a80f936730"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1lgtYjGkbx6ejTpNpZprD+9bUdNrEhrWG2uV51qnCkkioRLJZ2aV8OetA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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -11.512925464970204`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], FrameTicks -> {{{{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000], \
-115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000], \
-110.52408446371419`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000], \
-105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000], \
-101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000], -96.70857390574992], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000], -92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000], -87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000], -82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000], -78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000000], -73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000000000], -69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000000000], -64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000], -55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000], -50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000], -41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000], -36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000], 23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000], 27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000], 32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000], 41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000], 46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000], 55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000], 59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000], 69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-11.512925464970229`, 
      6.907755278982137}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Monodisperse\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 10\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 100\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"R\\\",FontSlant->\\\"Italic\\\"]]\\) = 250\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"], ",", 
                 RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                 RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"False", ",", "Automatic"}], "}"}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", "True", "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.9060158094145875`*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"502e2721-0093-4277-99b7-14d5f2fbc2c6"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1428., 735.75},
WindowMargins->{{-1465.5, Automatic}, {Automatic, 51}},
Magnification:>0.7 Inherited,
FrontEndVersion->"13.2 for Microsoft Windows (64-bit) (January 30, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"7b4b0030-b6c3-40d0-9cc1-2df637420d8e"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 291, 4, 68, "Title",ExpressionUUID->"9752d005-1219-465f-8e60-2082113917f8"],
Cell[874, 28, 568, 12, 40, "Text",ExpressionUUID->"49403409-d150-494f-b081-91ce56c28d83"],
Cell[1445, 42, 275, 6, 22, "Item",ExpressionUUID->"c5bb304f-f48f-4254-b437-103257a6e918"],
Cell[1723, 50, 453, 9, 22, "Item",ExpressionUUID->"ae041ac8-eae0-47a3-9bd9-39e8721130f8"],
Cell[CellGroupData[{
Cell[2201, 63, 180, 3, 32, "Subsubsection",ExpressionUUID->"e214e2f0-1723-47e3-b5e6-cc97977345b1"],
Cell[2384, 68, 421, 11, 34, "Input",ExpressionUUID->"6a1e2f36-ed4d-4204-a5ee-f5fb0ba7e773"],
Cell[CellGroupData[{
Cell[2830, 83, 4864, 92, 140, "Input",ExpressionUUID->"bb5b9391-51b5-4754-9301-f8ac33c801e3"],
Cell[7697, 177, 745, 11, 23, "Output",ExpressionUUID->"183a5e45-4fac-4246-945a-ca2643ce2245"],
Cell[8445, 190, 595, 9, 23, "Output",ExpressionUUID->"c85570ae-a5fa-467d-a6c7-3817ec81e012"]
}, Open  ]],
Cell[9055, 202, 2216, 53, 180, "Input",ExpressionUUID->"fc5fd8e9-fab4-4b5c-b2af-d0e7dff8366f"],
Cell[11274, 257, 6774, 174, 247, "Input",ExpressionUUID->"963c927a-6081-41b1-bcc3-11370c5e23da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18085, 436, 269, 5, 32, "Subsubsection",ExpressionUUID->"bb1efd3e-4cfd-424b-89f2-969547bc7a05"],
Cell[CellGroupData[{
Cell[18379, 445, 31227, 720, 2043, "Input",ExpressionUUID->"f2858960-ee9b-434f-ab6f-b0967ca77d38"],
Cell[49609, 1167, 6574, 103, 90, "Output",ExpressionUUID->"1c61ac8d-89bd-4e57-a2dd-0f614992ba6e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56232, 1276, 217, 4, 37, "Subsection",ExpressionUUID->"9ecbbbc5-8b8f-4847-b220-8094510e4a4e"],
Cell[56452, 1282, 335, 7, 24, "Text",ExpressionUUID->"1226fcdb-2e55-460d-933b-f363aeb6389f"],
Cell[CellGroupData[{
Cell[56812, 1293, 16752, 387, 1099, "Input",ExpressionUUID->"904598d3-3be1-4b29-9812-e84f814faf5c"],
Cell[73567, 1682, 155, 2, 23, "Output",ExpressionUUID->"681e62bd-fb47-4130-8710-47d38660d883"],
Cell[73725, 1686, 839, 25, 55, "Output",ExpressionUUID->"ba2a6a4f-07e6-457d-8b60-12614192001f"]
}, Open  ]],
Cell[74579, 1714, 12600, 254, 478, "Input",ExpressionUUID->"4d2ca9cf-a791-490d-b630-3cfaa5886fc0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87216, 1973, 160, 3, 47, "Section",ExpressionUUID->"ea7d68f2-5356-49b3-95f0-1a6e38787f2a"],
Cell[87379, 1978, 667, 16, 34, "Input",ExpressionUUID->"1e2ec847-da37-43d8-8641-1323717c97b4"],
Cell[CellGroupData[{
Cell[88071, 1998, 217, 5, 37, "Subsection",ExpressionUUID->"2c7e915b-284b-4a52-9077-42b65bc60a51"],
Cell[88291, 2005, 492, 9, 40, "Text",ExpressionUUID->"0716ec73-f7da-4d51-adfc-df2d5f6b72d6"],
Cell[88786, 2016, 7074, 192, 167, "Input",ExpressionUUID->"3ff1d24a-bfe7-4aef-b22b-89321bdbef81"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[95921, 2215, 153, 3, 68, "Title",ExpressionUUID->"d8104e96-bcdf-4d40-8ea7-520991da3e70"],
Cell[CellGroupData[{
Cell[96099, 2222, 14631, 305, 1314, "Input",ExpressionUUID->"ccb04c64-cfac-4dcb-b945-caef09e3f7b0"],
Cell[110733, 2529, 26989, 628, 234, "Output",ExpressionUUID->"cdd20bd3-2f84-4cfd-ad8a-6627a7493a28"],
Cell[137725, 3159, 26867, 625, 234, "Output",ExpressionUUID->"51f87ca9-45e3-451f-b17c-cbdbbcec9e4b"],
Cell[164595, 3786, 22267, 515, 245, "Output",ExpressionUUID->"83368012-51f3-43dd-aa4d-75e23d01a61c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[186899, 4306, 1419, 38, 100, "Input",ExpressionUUID->"f59751bb-bd6c-4cae-9851-1a4226146c36"],
Cell[188321, 4346, 166, 2, 23, "Output",ExpressionUUID->"937579c3-e20e-4c7f-b11c-af47d9c31b80"],
Cell[188490, 4350, 169, 2, 23, "Output",ExpressionUUID->"27806da8-4279-43e9-a922-b3a2dae493f8"],
Cell[188662, 4354, 170, 3, 23, "Output",ExpressionUUID->"4cb789d9-4655-49af-a847-7642ce402980"],
Cell[188835, 4359, 171, 3, 23, "Output",ExpressionUUID->"56122980-fd03-44b0-af02-c1d561e6d9dd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189043, 4367, 11361, 284, 345, "Input",ExpressionUUID->"f2ddb865-f2cf-400a-84b0-938fe3862f71"],
Cell[200407, 4653, 536, 12, 20, "Message",ExpressionUUID->"8d1f3ab5-5140-4506-905b-f751544f18a2"],
Cell[200946, 4667, 535, 12, 20, "Message",ExpressionUUID->"091fa113-791a-4dc3-8dba-4a6ac8a4d8fe"],
Cell[201484, 4681, 535, 12, 20, "Message",ExpressionUUID->"a8d11861-2790-4b40-a04f-69f3fb2441eb"],
Cell[202022, 4695, 502, 11, 20, "Message",ExpressionUUID->"0eb42261-2f57-4901-8244-8101ceaa7860"],
Cell[202527, 4708, 151227, 3496, 173, "Output",ExpressionUUID->"729e95fa-2829-4d9a-aeb5-4804aac10751"],
Cell[353757, 8206, 367, 6, 23, "Output",ExpressionUUID->"91493871-f28d-44bc-85c2-b07de19d6b67"]
}, Open  ]],
Cell[CellGroupData[{
Cell[354161, 8217, 10519, 262, 332, "Input",ExpressionUUID->"ad10af04-9d62-4a8c-bd41-9f9ed35934cd"],
Cell[364683, 8481, 509, 11, 20, "Message",ExpressionUUID->"e250c419-bd3d-4f1c-8e0d-dbd20786bc8b"],
Cell[365195, 8494, 510, 11, 20, "Message",ExpressionUUID->"1a9bfc75-1d42-4578-a14c-39c2a4800593"],
Cell[365708, 8507, 510, 11, 20, "Message",ExpressionUUID->"5d50cc9e-04b0-482d-8a8d-050de331ee4d"],
Cell[366221, 8520, 479, 10, 20, "Message",ExpressionUUID->"1a6fd400-0c23-4754-a2a6-e47bae0a4cdf"],
Cell[366703, 8532, 59756, 1275, 183, "Output",ExpressionUUID->"80bb1403-1c4e-48e1-9783-bf8fd5504e7c"],
Cell[426462, 9809, 350, 5, 23, "Output",ExpressionUUID->"78569c7d-162d-49f7-803a-c5c82cd19ed0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[426849, 9819, 10753, 270, 332, "Input",ExpressionUUID->"48a44b2d-5a2c-4c89-9786-d0ed942db9eb"],
Cell[437605, 10091, 512, 11, 20, "Message",ExpressionUUID->"67a8287c-709d-47bc-8a6d-b0b7d5342d1e"],
Cell[438120, 10104, 513, 11, 20, "Message",ExpressionUUID->"387b0686-5582-4505-b2e3-45cfce5846ab"],
Cell[438636, 10117, 510, 11, 20, "Message",ExpressionUUID->"71e9fdce-e825-4326-b63e-07de7691ed1f"],
Cell[439149, 10130, 479, 10, 20, "Message",ExpressionUUID->"4bda31ff-5d69-4bfd-ae65-03225756b935"],
Cell[439631, 10142, 45235, 998, 183, "Output",ExpressionUUID->"c9f4fe1c-0fa3-47fa-b504-e3448df9cf67"],
Cell[484869, 11142, 365, 6, 23, "Output",ExpressionUUID->"156f324a-97d0-4923-a6e7-87b79039a71c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[485271, 11153, 5555, 137, 239, "Input",ExpressionUUID->"6d91c493-1444-458a-a1c2-88a80f936730"],
Cell[490829, 11292, 67975, 1621, 179, "Output",ExpressionUUID->"502e2721-0093-4277-99b7-14d5f2fbc2c6"]
}, Open  ]]
}, Open  ]]
}
]
*)

